/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.covered.CoveredColumns;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.data.IndexMemStore;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.hbase.index.scanner.ScannerBuilder;

public class LocalTableState
implements TableState {
    private long ts;
    private RegionCoprocessorEnvironment env;
    private KeyValueStore memstore;
    private LocalHBaseState table;
    private Mutation update;
    private Set<ColumnTracker> trackedColumns = new HashSet<ColumnTracker>();
    private ScannerBuilder scannerBuilder;
    private List<KeyValue> kvs = new ArrayList<KeyValue>();
    private List<? extends IndexedColumnGroup> hints;
    private CoveredColumns columnSet;

    public LocalTableState(RegionCoprocessorEnvironment environment, LocalHBaseState table, Mutation update) {
        this.env = environment;
        this.table = table;
        this.update = update;
        this.memstore = new IndexMemStore();
        this.scannerBuilder = new ScannerBuilder(this.memstore, update);
        this.columnSet = new CoveredColumns();
    }

    public void addPendingUpdates(KeyValue ... kvs) {
        if (kvs == null) {
            return;
        }
        this.addPendingUpdates(Arrays.asList(kvs));
    }

    public void addPendingUpdates(List<KeyValue> kvs) {
        if (kvs == null) {
            return;
        }
        this.setPendingUpdates(kvs);
        this.addUpdate(kvs);
    }

    private void addUpdate(List<KeyValue> list) {
        this.addUpdate(list, true);
    }

    private void addUpdate(List<KeyValue> list, boolean overwrite) {
        if (list == null) {
            return;
        }
        for (KeyValue kv : list) {
            this.memstore.add(kv, overwrite);
        }
    }

    @Override
    public RegionCoprocessorEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public long getCurrentTimestamp() {
        return this.ts;
    }

    @Override
    public void setCurrentTimestamp(long timestamp) {
        this.ts = timestamp;
    }

    public void resetTrackedColumns() {
        this.trackedColumns.clear();
    }

    public Set<ColumnTracker> getTrackedColumns() {
        return this.trackedColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Scanner, IndexUpdate> getIndexedColumnsTableState(Collection<? extends ColumnReference> indexedColumns) throws IOException {
        this.ensureLocalStateInitialized(indexedColumns);
        ColumnTracker tracker = new ColumnTracker(indexedColumns);
        Set<ColumnTracker> set = this.trackedColumns;
        synchronized (set) {
            if (!this.trackedColumns.contains(tracker)) {
                this.trackedColumns.add(tracker);
            }
        }
        Scanner scanner = this.scannerBuilder.buildIndexedColumnScanner(indexedColumns, tracker, this.ts);
        return new Pair<Scanner, IndexUpdate>(scanner, new IndexUpdate(tracker));
    }

    private synchronized void ensureLocalStateInitialized(Collection<? extends ColumnReference> columns) throws IOException {
        Collection<? extends ColumnReference> toCover = this.columnSet.findNonCoveredColumns(columns);
        if (toCover.isEmpty()) {
            return;
        }
        this.addUpdate(this.table.getCurrentRowState(this.update, toCover).list(), false);
        for (ColumnReference columnReference : toCover) {
            this.columnSet.addColumn(columnReference);
        }
    }

    @Override
    public Map<String, byte[]> getUpdateAttributes() {
        return this.update.getAttributesMap();
    }

    @Override
    public byte[] getCurrentRowKey() {
        return this.update.getRow();
    }

    public Result getCurrentRowState() {
        KeyValueScanner scanner = this.memstore.getScanner();
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        while (scanner.peek() != null) {
            try {
                kvs.add(scanner.next());
            }
            catch (IOException e) {
                throw new RuntimeException("Local MemStore threw IOException!");
            }
        }
        return Result.create(kvs);
    }

    public void addUpdateForTesting(Mutation pendingUpdate) {
        for (Map.Entry e : pendingUpdate.getFamilyCellMap().entrySet()) {
            List<KeyValue> edits = KeyValueUtil.ensureKeyValues((List)e.getValue());
            this.addUpdate(edits);
        }
    }

    public void setHints(List<? extends IndexedColumnGroup> hints) {
        this.hints = hints;
    }

    @Override
    public List<? extends IndexedColumnGroup> getIndexColumnHints() {
        return this.hints;
    }

    @Override
    public Collection<KeyValue> getPendingUpdate() {
        return this.kvs;
    }

    public void setPendingUpdates(Collection<KeyValue> update) {
        this.kvs.clear();
        this.kvs.addAll(update);
    }

    public void applyPendingUpdates() {
        this.addUpdate(this.kvs);
    }

    public void rollback(Collection<KeyValue> values) {
        for (KeyValue kv : values) {
            this.memstore.rollback(kv);
        }
    }
}

