/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;

public class FamilyOnlyFilter
extends FamilyFilter {
    boolean done = false;
    private boolean previousMatchFound;

    public FamilyOnlyFilter(byte[] family) {
        this(new BinaryComparator(family));
    }

    public FamilyOnlyFilter(ByteArrayComparable familyComparator) {
        super(CompareFilter.CompareOp.EQUAL, familyComparator);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    @Override
    public void reset() {
        this.done = false;
        this.previousMatchFound = false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.done) {
            return Filter.ReturnCode.SKIP;
        }
        Filter.ReturnCode code = super.filterKeyValue(v);
        if (this.previousMatchFound) {
            if (code.equals((Object)Filter.ReturnCode.SKIP)) {
                this.done = true;
            }
        } else if (code.equals((Object)Filter.ReturnCode.INCLUDE)) {
            this.previousMatchFound = true;
        }
        return code;
    }
}

