/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class ColumnReference
implements Comparable<ColumnReference> {
    public static final byte[] ALL_QUALIFIERS = new byte[0];
    private final int hashCode;
    protected final byte[] family;
    protected final byte[] qualifier;
    private volatile ImmutableBytesWritable familyPtr;
    private volatile ImmutableBytesWritable qualifierPtr;

    private static int calcHashCode(byte[] family, byte[] qualifier) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Bytes.hashCode(family);
        result = 31 * result + Bytes.hashCode(qualifier);
        return result;
    }

    public ColumnReference(byte[] family, byte[] qualifier) {
        this.family = family;
        this.qualifier = qualifier;
        this.hashCode = ColumnReference.calcHashCode(family, qualifier);
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImmutableBytesWritable getFamilyWritable() {
        if (this.familyPtr != null) return this.familyPtr;
        byte[] byArray = this.family;
        synchronized (this.family) {
            if (this.familyPtr != null) return this.familyPtr;
            this.familyPtr = new ImmutableBytesPtr(this.family);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.familyPtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImmutableBytesWritable getQualifierWritable() {
        if (this.qualifierPtr != null) return this.qualifierPtr;
        byte[] byArray = this.qualifier;
        synchronized (this.qualifier) {
            if (this.qualifierPtr != null) return this.qualifierPtr;
            this.qualifierPtr = new ImmutableBytesPtr(this.qualifier);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.qualifierPtr;
        }
    }

    public boolean matches(KeyValue kv) {
        if (this.matchesFamily(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength())) {
            return this.matchesQualifier(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
        }
        return false;
    }

    public boolean matchesQualifier(byte[] qual) {
        return this.matchesQualifier(qual, 0, qual.length);
    }

    public boolean matchesQualifier(byte[] bytes, int offset, int length) {
        return this.allColumns() ? true : this.match(bytes, offset, length, this.qualifier);
    }

    public boolean matchesFamily(byte[] family) {
        return this.matchesFamily(family, 0, family.length);
    }

    public boolean matchesFamily(byte[] bytes, int offset, int length) {
        return this.match(bytes, offset, length, this.family);
    }

    public boolean allColumns() {
        return this.qualifier == ALL_QUALIFIERS;
    }

    private boolean match(byte[] first, int offset, int length, byte[] storedKey) {
        return first == null ? false : Bytes.equals(first, offset, length, storedKey, 0, storedKey.length);
    }

    public KeyValue getFirstKeyValueForRow(byte[] row) {
        return KeyValue.createFirstOnRow(row, this.family, this.qualifier == ALL_QUALIFIERS ? null : this.qualifier);
    }

    @Override
    public int compareTo(ColumnReference o) {
        int c = Bytes.compareTo(this.family, o.family);
        if (c == 0) {
            c = Bytes.compareTo(this.qualifier, o.qualifier);
        }
        return c;
    }

    public boolean equals(Object o) {
        if (o instanceof ColumnReference) {
            ColumnReference other = (ColumnReference)o;
            if (this.hashCode == other.hashCode && Bytes.equals(this.family, other.family)) {
                return Bytes.equals(this.qualifier, other.qualifier);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ColumnReference - " + Bytes.toString(this.family) + ":" + Bytes.toString(this.qualifier);
    }
}

