/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;

public class ColumnTracker
implements IndexedColumnGroup {
    public static final long NO_NEWER_PRIMARY_TABLE_ENTRY_TIMESTAMP = Long.MAX_VALUE;
    public static final long GUARANTEED_NEWER_UPDATES = Long.MIN_VALUE;
    private final List<ColumnReference> columns;
    private long ts = Long.MAX_VALUE;
    private final int hashCode;

    private static int calcHashCode(List<ColumnReference> columns) {
        return ((Object)columns).hashCode();
    }

    public ColumnTracker(Collection<? extends ColumnReference> columns) {
        this.columns = new ArrayList<ColumnReference>(columns);
        Collections.sort(this.columns);
        this.hashCode = ColumnTracker.calcHashCode(this.columns);
    }

    public long setTs(long ts) {
        this.ts = this.ts > ts ? ts : this.ts;
        return this.ts;
    }

    public long getTS() {
        return this.ts;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColumnTracker)) {
            return false;
        }
        ColumnTracker other = (ColumnTracker)o;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (other.columns.size() != this.columns.size()) {
            return false;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).equals(other.columns.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ColumnReference> getColumns() {
        return this.columns;
    }

    public boolean hasNewerTimestamps() {
        return !ColumnTracker.isNewestTime(this.ts);
    }

    public static boolean isNewestTime(long ts) {
        return ts == Long.MAX_VALUE;
    }
}

