/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.phoenix.hbase.index.parallel.Task;

public class TaskBatch<V>
implements Abortable {
    private static final Log LOG = LogFactory.getLog(TaskBatch.class);
    private AtomicBoolean aborted = new AtomicBoolean();
    private List<Task<V>> tasks;

    public TaskBatch(int size) {
        this.tasks = new ArrayList<Task<V>>(size);
    }

    public void add(Task<V> task) {
        this.tasks.add(task);
        task.setBatchMonitor(this);
    }

    public Collection<Task<V>> getTasks() {
        return this.tasks;
    }

    @Override
    public void abort(String why, Throwable e) {
        if (this.aborted.getAndSet(true)) {
            return;
        }
        LOG.info("Aborting batch of tasks because " + why);
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    public int size() {
        return this.tasks.size();
    }
}

