/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.table;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class CoprocessorHTableFactory
implements HTableFactory {
    private static final String ZOOKEEPER_RECOVERY_RETRY_INTERVALMILL = "zookeeper.recovery.retry.intervalmill";
    private static final String ZOOKEEPER_RECOVERY_RETRY_KEY = "zookeeper.recovery.retry";
    private static final Log LOG = LogFactory.getLog(CoprocessorHTableFactory.class);
    private CoprocessorEnvironment e;

    public CoprocessorHTableFactory(CoprocessorEnvironment e) {
        this.e = e;
    }

    @Override
    public HTableInterface getTable(ImmutableBytesPtr tablename) throws IOException {
        Configuration conf = this.e.getConfiguration();
        IndexManagementUtil.setIfNotSet(conf, HConstants.HBASE_CLIENT_RETRIES_NUMBER, 3);
        IndexManagementUtil.setIfNotSet(conf, HConstants.HBASE_CLIENT_PAUSE, 1000);
        IndexManagementUtil.setIfNotSet(conf, ZOOKEEPER_RECOVERY_RETRY_KEY, 3);
        IndexManagementUtil.setIfNotSet(conf, ZOOKEEPER_RECOVERY_RETRY_INTERVALMILL, 100);
        IndexManagementUtil.setIfNotSet(conf, "zookeeper.session.timeout", 30000);
        IndexManagementUtil.setIfNotSet(conf, HConstants.HBASE_RPC_TIMEOUT_KEY, 5000);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new HTable: " + Bytes.toString(tablename.copyBytesIfNecessary()));
        }
        return this.e.getTable(TableName.valueOf(tablename.copyBytesIfNecessary()));
    }

    @Override
    public void shutdown() {
    }
}

