/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.builder.IndexBuildingFailureException;
import org.apache.phoenix.hbase.index.covered.data.LazyValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class IndexManagementUtil {
    public static final String INDEX_WAL_EDIT_CODEC_CLASS_NAME = "org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec";
    public static final String HLOG_READER_IMPL_KEY = "hbase.regionserver.hlog.reader.impl";
    public static final String WAL_EDIT_CODEC_CLASS_KEY = "hbase.regionserver.wal.codec";
    private static final String INDEX_HLOG_READER_CLASS_NAME = "org.apache.hadoop.hbase.regionserver.wal.IndexedHLogReader";
    private static final Log LOG = LogFactory.getLog(IndexManagementUtil.class);

    private IndexManagementUtil() {
    }

    public static boolean isWALEditCodecSet(Configuration conf) {
        try {
            Class.forName(INDEX_WAL_EDIT_CODEC_CLASS_NAME);
        }
        catch (Throwable t) {
            return false;
        }
        return INDEX_WAL_EDIT_CODEC_CLASS_NAME.equals(conf.get(WAL_EDIT_CODEC_CLASS_KEY, null));
    }

    public static void ensureMutableIndexingCorrectlyConfigured(Configuration conf) throws IllegalStateException {
        if (IndexManagementUtil.isWALEditCodecSet(conf)) {
            return;
        }
        String codecClass = INDEX_WAL_EDIT_CODEC_CLASS_NAME;
        String indexLogReaderName = INDEX_HLOG_READER_CLASS_NAME;
        try {
            Class.forName(indexLogReaderName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(codecClass + " is not installed, but " + indexLogReaderName + " hasn't been installed in hbase-site.xml under " + HLOG_READER_IMPL_KEY);
        }
        if (indexLogReaderName.equals(conf.get(HLOG_READER_IMPL_KEY, indexLogReaderName))) {
            if (conf.getBoolean("hbase.regionserver.wal.enablecompression", false)) {
                throw new IllegalStateException("WAL Compression is only supported with " + codecClass + ". You can install in hbase-site.xml, under " + WAL_EDIT_CODEC_CLASS_KEY);
            }
        } else {
            throw new IllegalStateException(codecClass + " is not installed, but " + indexLogReaderName + " hasn't been installed in hbase-site.xml under " + HLOG_READER_IMPL_KEY);
        }
    }

    public static ValueGetter createGetterFromKeyValues(Collection<KeyValue> pendingUpdates) {
        final HashMap<ReferencingColumn, ImmutableBytesPtr> valueMap = Maps.newHashMapWithExpectedSize(pendingUpdates.size());
        for (KeyValue kv : pendingUpdates) {
            ImmutableBytesPtr family = new ImmutableBytesPtr(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength());
            ImmutableBytesPtr qual = new ImmutableBytesPtr(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
            ImmutableBytesPtr value = new ImmutableBytesPtr(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
            valueMap.put(new ReferencingColumn(family, qual), value);
        }
        return new ValueGetter(){

            @Override
            public ImmutableBytesPtr getLatestValue(ColumnReference ref) throws IOException {
                return (ImmutableBytesPtr)valueMap.get(ReferencingColumn.wrap(ref));
            }
        };
    }

    public static ValueGetter createGetterFromScanner(Scanner scanner, byte[] currentRow) {
        return new LazyValueGetter(scanner, currentRow);
    }

    public static boolean updateMatchesColumns(Collection<KeyValue> update, List<ColumnReference> columns) {
        boolean matches = false;
        block0: for (KeyValue kv : update) {
            for (ColumnReference ref : columns) {
                if (!ref.matchesFamily(kv.getFamily()) || !ref.matchesQualifier(kv.getQualifier())) continue;
                matches = true;
                break block0;
            }
        }
        return matches;
    }

    public static boolean columnMatchesUpdate(List<ColumnReference> columns, Collection<KeyValue> update) {
        boolean matches = false;
        block0: for (ColumnReference ref : columns) {
            for (KeyValue kv : update) {
                if (!ref.matchesFamily(kv.getFamily()) || !ref.matchesQualifier(kv.getQualifier())) continue;
                matches = true;
                break block0;
            }
        }
        return matches;
    }

    public static Scan newLocalStateScan(List<? extends Iterable<? extends ColumnReference>> refsArray) {
        Scan s = new Scan();
        s.setRaw(true);
        for (Iterable<? extends ColumnReference> iterable : refsArray) {
            for (ColumnReference columnReference : iterable) {
                s.addFamily(columnReference.getFamily());
            }
        }
        s.setMaxVersions();
        return s;
    }

    public static void rethrowIndexingException(Throwable e) throws IOException {
        try {
            throw e;
        }
        catch (IOException e1) {
            LOG.info("Rethrowing " + e);
            throw e1;
        }
        catch (Throwable e1) {
            LOG.info("Rethrowing " + e1 + " as a " + IndexBuildingFailureException.class.getSimpleName());
            throw new IndexBuildingFailureException("Failed to build index for unexpected reason!", e1);
        }
    }

    public static void setIfNotSet(Configuration conf, String key, int value) {
        if (conf.get(key) == null) {
            conf.setInt(key, value);
        }
    }

    private static class ReferencingColumn {
        ImmutableBytesPtr family;
        ImmutableBytesPtr qual;

        static ReferencingColumn wrap(ColumnReference ref) {
            ImmutableBytesPtr family = new ImmutableBytesPtr(ref.getFamily());
            ImmutableBytesPtr qual = new ImmutableBytesPtr(ref.getQualifier());
            return new ReferencingColumn(family, qual);
        }

        public ReferencingColumn(ImmutableBytesPtr family, ImmutableBytesPtr qual) {
            this.family = family;
            this.qual = qual;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
            result = 31 * result + (this.qual == null ? 0 : this.qual.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferencingColumn other = (ReferencingColumn)obj;
            if (this.family == null ? other.family != null : !this.family.equals(other.family)) {
                return false;
            }
            return !(this.qual == null ? other.qual != null : !this.qual.equals(other.qual));
        }
    }
}

