/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class IndexedKeyValue
extends KeyValue {
    public static final byte[] COLUMN_FAMILY = Bytes.toBytes("INDEXEDKEYVALUE_FAKED_FAMILY");
    private ImmutableBytesPtr indexTableName;
    private Mutation mutation;
    private boolean batchFinished = false;
    private int hashCode;

    private static int calcHashCode(ImmutableBytesPtr indexTableName, Mutation mutation) {
        int prime = 31;
        int result = 1;
        result = 31 * result + indexTableName.hashCode();
        result = 31 * result + Arrays.hashCode(mutation.getRow());
        return result;
    }

    public IndexedKeyValue() {
    }

    public IndexedKeyValue(byte[] bs, Mutation mutation) {
        this.indexTableName = new ImmutableBytesPtr(bs);
        this.mutation = mutation;
        this.hashCode = IndexedKeyValue.calcHashCode(this.indexTableName, mutation);
    }

    public byte[] getIndexTable() {
        return this.indexTableName.get();
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    @Override
    public byte[] getFamily() {
        return COLUMN_FAMILY;
    }

    @Override
    public boolean matchingFamily(byte[] family) {
        return Bytes.equals(family, WALEdit.METAFAMILY);
    }

    @Override
    public boolean matchingRow(byte[] row) {
        return false;
    }

    @Override
    public String toString() {
        return "IndexWrite:\n\ttable: " + this.indexTableName + "\n\tmutation:" + this.mutation;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedKeyValue other = (IndexedKeyValue)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!other.indexTableName.equals(this.indexTableName)) {
            return false;
        }
        byte[] current = this.getMutationBytes();
        byte[] otherMutation = other.getMutationBytes();
        return Bytes.equals(current, otherMutation);
    }

    private byte[] getMutationBytes() {
        try {
            ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
            return m.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get bytes for mutation!", e);
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    void writeData(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.indexTableName.get());
        ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
        Bytes.writeByteArray(out, m.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        this.indexTableName = new ImmutableBytesPtr(Bytes.readByteArray(in));
        byte[] mutationData = Bytes.readByteArray(in);
        ClientProtos.MutationProto mProto = ClientProtos.MutationProto.parseFrom(mutationData);
        this.mutation = ProtobufUtil.toMutation(mProto);
        this.hashCode = IndexedKeyValue.calcHashCode(this.indexTableName, this.mutation);
    }

    public boolean getBatchFinished() {
        return this.batchFinished;
    }

    public void markBatchFinished() {
        this.batchFinished = true;
    }

    protected ClientProtos.MutationProto toMutationProto(Mutation mutation) throws IOException {
        ClientProtos.MutationProto m = null;
        if (mutation instanceof Put) {
            m = ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, mutation);
        } else if (mutation instanceof Delete) {
            m = ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, mutation);
        } else {
            throw new IOException("Put/Delete mutations only supported");
        }
        return m;
    }
}

