/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.hbase.index.write.ParallelWriterIndexCommitter;

public class IndexWriter
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(IndexWriter.class);
    private static final String INDEX_COMMITTER_CONF_KEY = "index.writer.commiter.class";
    public static final String INDEX_FAILURE_POLICY_CONF_KEY = "index.writer.failurepolicy.class";
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private IndexCommitter writer;
    private IndexFailurePolicy failurePolicy;

    public IndexWriter(RegionCoprocessorEnvironment env, String name) throws IOException {
        this(IndexWriter.getCommitter(env), IndexWriter.getFailurePolicy(env), env, name);
    }

    public static IndexCommitter getCommitter(RegionCoprocessorEnvironment env) throws IOException {
        Configuration conf = env.getConfiguration();
        try {
            IndexCommitter committer = conf.getClass(INDEX_COMMITTER_CONF_KEY, ParallelWriterIndexCommitter.class, IndexCommitter.class).newInstance();
            return committer;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public static IndexFailurePolicy getFailurePolicy(RegionCoprocessorEnvironment env) throws IOException {
        Configuration conf = env.getConfiguration();
        try {
            IndexFailurePolicy committer = conf.getClass(INDEX_FAILURE_POLICY_CONF_KEY, KillServerOnFailurePolicy.class, IndexFailurePolicy.class).newInstance();
            return committer;
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public IndexWriter(IndexCommitter committer, IndexFailurePolicy policy, RegionCoprocessorEnvironment env, String name) {
        this(committer, policy);
        this.writer.setup(this, env, name);
        this.failurePolicy.setup(this, env);
    }

    IndexWriter(IndexCommitter committer, IndexFailurePolicy policy) {
        this.writer = committer;
        this.failurePolicy = policy;
    }

    public void writeAndKillYourselfOnFailure(Collection<Pair<Mutation, byte[]>> indexUpdates) throws IOException {
        Multimap<HTableInterfaceReference, Mutation> toWrite = IndexWriter.resolveTableReferences(indexUpdates);
        this.writeAndKillYourselfOnFailure(toWrite);
    }

    public void writeAndKillYourselfOnFailure(Multimap<HTableInterfaceReference, Mutation> toWrite) throws IOException {
        try {
            this.write(toWrite);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Done writing all index updates!\n\t" + toWrite);
            }
        }
        catch (Exception e) {
            this.failurePolicy.handleFailure(toWrite, e);
        }
    }

    public void write(Collection<Pair<Mutation, byte[]>> toWrite) throws IndexWriteException {
        this.write(IndexWriter.resolveTableReferences(toWrite));
    }

    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite) throws IndexWriteException {
        this.writer.write(toWrite);
    }

    public static Multimap<HTableInterfaceReference, Mutation> resolveTableReferences(Collection<Pair<Mutation, byte[]>> indexUpdates) {
        ArrayListMultimap<HTableInterfaceReference, Mutation> updates = ArrayListMultimap.create();
        HashMap<ImmutableBytesPtr, HTableInterfaceReference> tables = new HashMap<ImmutableBytesPtr, HTableInterfaceReference>(updates.size());
        for (Pair<Mutation, byte[]> entry : indexUpdates) {
            byte[] tableName = entry.getSecond();
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(tableName);
            HTableInterfaceReference table = (HTableInterfaceReference)tables.get(ptr);
            if (table == null) {
                table = new HTableInterfaceReference(ptr);
                tables.put(ptr, table);
            }
            updates.put(table, entry.getFirst());
        }
        return updates;
    }

    @Override
    public void stop(String why) {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Stopping because " + why);
        this.writer.stop(why);
        this.failurePolicy.stop(why);
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }
}

