/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;

public class KillServerOnFailurePolicy
implements IndexFailurePolicy {
    private static final Log LOG = LogFactory.getLog(KillServerOnFailurePolicy.class);
    private Abortable abortable;
    private Stoppable stoppable;

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        this.setup(parent, env.getRegionServerServices());
    }

    public void setup(Stoppable parent, Abortable abort) {
        this.stoppable = parent;
        this.abortable = abort;
    }

    @Override
    public void stop(String why) {
    }

    @Override
    public boolean isStopped() {
        return this.stoppable.isStopped();
    }

    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        this.stop("Killing ourselves because of an error:" + cause);
        String msg = "Could not update the index table, killing server region because couldn't write to an index table";
        LOG.error(msg, cause);
        try {
            this.abortable.abort(msg, cause);
        }
        catch (Exception e) {
            LOG.fatal("Couldn't abort this server to preserve index writes, attempting to hard kill the server");
            System.exit(1);
        }
    }
}

