/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.util.BitSet;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class IndexMaintainer
implements Writable,
Iterable<ColumnReference> {
    private byte[] viewIndexId;
    private boolean isMultiTenant;
    private Set<ColumnReference> indexedColumns;
    private Set<ColumnReference> coveredColumns;
    private Set<ColumnReference> allColumns;
    private List<PDataType> indexedColumnTypes;
    private RowKeyMetaData rowKeyMetaData;
    private byte[] indexTableName;
    private int nIndexSaltBuckets;
    private byte[] dataEmptyKeyValueCF;
    private ImmutableBytesPtr emptyKeyValueCFPtr;
    private int nDataCFs;
    private boolean indexWALDisabled;
    private final boolean isDataTableSalted;
    private final RowKeySchema dataRowKeySchema;
    private List<ImmutableBytesPtr> indexQualifiers;
    private int estimatedIndexRowKeyBytes;
    private int[] dataPkPosition;
    private int maxTrailingNulls;
    private ColumnReference dataEmptyKeyValueRef;
    private static int BYTE_OFFSET = 127;

    public static IndexMaintainer create(PTable dataTable, PTable index) {
        int i;
        if (dataTable.getType() == PTableType.INDEX || index.getType() != PTableType.INDEX || !dataTable.getIndexes().contains(index)) {
            throw new IllegalArgumentException();
        }
        IndexMaintainer maintainer = new IndexMaintainer(dataTable, index);
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (maintainer.isMultiTenant ? 1 : 0) + (maintainer.viewIndexId == null ? 0 : 1);
        RowKeyMetaData rowKeyMetaData = maintainer.getRowKeyMetaData();
        int indexColByteSize = 0;
        for (i = indexPosOffset; i < index.getPKColumns().size(); ++i) {
            PColumn indexColumn = index.getPKColumns().get(i);
            int indexPos = i - indexPosOffset;
            PColumn column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
            boolean isPKColumn = SchemaUtil.isPKColumn(column);
            if (isPKColumn) {
                int dataPkPos = dataTable.getPKColumns().indexOf(column) - (dataTable.getBucketNum() == null ? 0 : 1) - (maintainer.isMultiTenant ? 1 : 0);
                rowKeyMetaData.setIndexPkPosition(dataPkPos, indexPos);
            } else {
                indexColByteSize += column.getDataType().isFixedWidth() ? SchemaUtil.getFixedByteSize(column) : 10;
                maintainer.getIndexedColumnTypes().add(column.getDataType());
                maintainer.getIndexedColumns().add(new ColumnReference(column.getFamilyName().getBytes(), column.getName().getBytes()));
            }
            if (indexColumn.getSortOrder() != SortOrder.DESC) continue;
            rowKeyMetaData.getDescIndexColumnBitSet().set(indexPos);
        }
        for (i = 0; i < index.getColumnFamilies().size(); ++i) {
            PColumnFamily family = index.getColumnFamilies().get(i);
            for (PColumn indexColumn : family.getColumns()) {
                PColumn column = IndexUtil.getDataColumn(dataTable, indexColumn.getName().getString());
                maintainer.getCoverededColumns().add(new ColumnReference(column.getFamilyName().getBytes(), column.getName().getBytes()));
            }
        }
        maintainer.estimatedIndexRowKeyBytes = maintainer.estimateIndexRowKeyByteSize(indexColByteSize);
        maintainer.initCachedState();
        return maintainer;
    }

    public static Iterator<PTable> nonDisabledIndexIterator(Iterator<PTable> indexes) {
        return Iterators.filter(indexes, new Predicate<PTable>(){

            @Override
            public boolean apply(PTable index) {
                return !PIndexState.DISABLE.equals((Object)index.getIndexState());
            }
        });
    }

    public static void serialize(PTable dataTable, ImmutableBytesWritable ptr) {
        Iterator<PTable> indexes = IndexMaintainer.nonDisabledIndexIterator(dataTable.getIndexes().iterator());
        if (dataTable.isImmutableRows() || !indexes.hasNext()) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        int nIndexes = 0;
        int estimatedSize = dataTable.getRowKeySchema().getEstimatedByteSize() + 2;
        while (indexes.hasNext()) {
            ++nIndexes;
            PTable index = indexes.next();
            estimatedSize += index.getIndexMaintainer(dataTable).getEstimatedByteSize();
        }
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(estimatedSize + 1);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            WritableUtils.writeVInt(output, nIndexes * (dataTable.getBucketNum() == null ? 1 : -1));
            dataTable.getRowKeySchema().write(output);
            indexes = IndexMaintainer.nonDisabledIndexIterator(dataTable.getIndexes().iterator());
            while (indexes.hasNext()) {
                indexes.next().getIndexMaintainer(dataTable).write(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ptr.set(stream.getBuffer(), 0, stream.size());
    }

    public static List<IndexMaintainer> deserialize(ImmutableBytesWritable metaDataPtr, KeyValueBuilder builder) {
        return IndexMaintainer.deserialize(metaDataPtr.get(), metaDataPtr.getOffset(), metaDataPtr.getLength());
    }

    public static List<IndexMaintainer> deserialize(byte[] buf) {
        return IndexMaintainer.deserialize(buf, 0, buf.length);
    }

    public static List<IndexMaintainer> deserialize(byte[] buf, int offset, int length) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buf, offset, length);
        DataInputStream input = new DataInputStream(stream);
        List<IndexMaintainer> maintainers = Collections.emptyList();
        try {
            int size = WritableUtils.readVInt(input);
            boolean isDataTableSalted = size < 0;
            size = Math.abs(size);
            RowKeySchema rowKeySchema = new RowKeySchema();
            rowKeySchema.readFields(input);
            maintainers = Lists.newArrayListWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                IndexMaintainer maintainer = new IndexMaintainer(rowKeySchema, isDataTableSalted);
                maintainer.readFields(input);
                maintainers.add(maintainer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return maintainers;
    }

    private IndexMaintainer(RowKeySchema dataRowKeySchema, boolean isDataTableSalted) {
        this.dataRowKeySchema = dataRowKeySchema;
        this.isDataTableSalted = isDataTableSalted;
    }

    private IndexMaintainer(PTable dataTable, PTable index) {
        this(dataTable.getRowKeySchema(), dataTable.getBucketNum() != null);
        this.isMultiTenant = dataTable.isMultiTenant();
        this.viewIndexId = index.getViewIndexId() == null ? null : MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId());
        RowKeySchema dataRowKeySchema = dataTable.getRowKeySchema();
        boolean isDataTableSalted = dataTable.getBucketNum() != null;
        byte[] indexTableName = index.getPhysicalName().getBytes();
        Integer nIndexSaltBuckets = index.getBucketNum();
        boolean indexWALDisabled = index.isWALDisabled();
        int indexPosOffset = (index.getBucketNum() == null ? 0 : 1) + (this.isMultiTenant ? 1 : 0) + (this.viewIndexId == null ? 0 : 1);
        int nIndexColumns = index.getColumns().size() - indexPosOffset;
        int nIndexPKColumns = index.getPKColumns().size() - indexPosOffset;
        this.rowKeyMetaData = this.newRowKeyMetaData(nIndexPKColumns);
        BitSet bitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        int dataPosOffset = (isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nDataPKColumns = dataRowKeySchema.getFieldCount() - dataPosOffset;
        if (dataTable.getType() == PTableType.VIEW) {
            List<PColumn> dataPKColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPKColumns.size(); ++i) {
                PColumn dataPKColumn = dataPKColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                bitSet.set(i);
                --nDataPKColumns;
            }
        }
        this.indexTableName = indexTableName;
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize(nIndexPKColumns - nDataPKColumns);
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize(nIndexPKColumns - nDataPKColumns);
        this.coveredColumns = Sets.newLinkedHashSetWithExpectedSize(nIndexColumns - nIndexPKColumns);
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize(nDataPKColumns + nIndexColumns);
        this.allColumns.addAll(this.indexedColumns);
        this.allColumns.addAll(this.coveredColumns);
        this.nIndexSaltBuckets = nIndexSaltBuckets == null ? 0 : nIndexSaltBuckets;
        this.dataEmptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(dataTable);
        this.emptyKeyValueCFPtr = SchemaUtil.getEmptyColumnFamilyPtr(index);
        this.nDataCFs = dataTable.getColumnFamilies().size();
        this.indexWALDisabled = indexWALDisabled;
    }

    public byte[] buildRowKey(ValueGetter valueGetter, ImmutableBytesWritable rowKeyPtr) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        TrustedByteArrayOutputStream stream = new TrustedByteArrayOutputStream(this.estimatedIndexRowKeyBytes);
        DataOutputStream output = new DataOutputStream(stream);
        try {
            int length;
            if (this.nIndexSaltBuckets > 0) {
                output.write(0);
            }
            int dataPosOffset = this.isDataTableSalted ? 1 : 0;
            int nIndexedColumns = this.getIndexPkColumnCount();
            int[][] dataRowKeyLocator = new int[2][nIndexedColumns];
            int maxRowKeyOffset = rowKeyPtr.getOffset() + rowKeyPtr.getLength();
            this.dataRowKeySchema.iterator(rowKeyPtr, ptr, dataPosOffset);
            if (this.isMultiTenant) {
                this.dataRowKeySchema.next(ptr, dataPosOffset, maxRowKeyOffset);
                output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                if (!this.dataRowKeySchema.getField(dataPosOffset).getDataType().isFixedWidth()) {
                    output.writeByte(0);
                }
                ++dataPosOffset;
            }
            if (this.viewIndexId != null) {
                output.write(this.viewIndexId);
            }
            BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
            for (int i = dataPosOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
                Boolean hasValue = this.dataRowKeySchema.next(ptr, i, maxRowKeyOffset);
                if (viewConstantColumnBitSet.get(i)) continue;
                int pos = this.rowKeyMetaData.getIndexPkPosition(i - dataPosOffset);
                if (Boolean.TRUE.equals(hasValue)) {
                    dataRowKeyLocator[0][pos] = ptr.getOffset();
                    dataRowKeyLocator[1][pos] = ptr.getLength();
                    continue;
                }
                dataRowKeyLocator[0][pos] = 0;
                dataRowKeyLocator[1][pos] = 0;
            }
            BitSet descIndexColumnBitSet = this.rowKeyMetaData.getDescIndexColumnBitSet();
            int j = 0;
            Iterator<ColumnReference> iterator = this.indexedColumns.iterator();
            for (int i = 0; i < nIndexedColumns; ++i) {
                PDataType dataColumnType;
                boolean isNullable = true;
                boolean isDataColumnInverted = false;
                SortOrder dataSortOrder = SortOrder.getDefault();
                if (this.dataPkPosition[i] == -1) {
                    dataColumnType = this.indexedColumnTypes.get(j);
                    ImmutableBytesPtr value = valueGetter.getLatestValue(iterator.next());
                    if (value == null) {
                        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                    } else {
                        ptr.set(value.copyBytesIfNecessary());
                    }
                    ++j;
                } else {
                    ValueSchema.Field field = this.dataRowKeySchema.getField(this.dataPkPosition[i]);
                    dataColumnType = field.getDataType();
                    ptr.set(rowKeyPtr.get(), dataRowKeyLocator[0][i], dataRowKeyLocator[1][i]);
                    dataSortOrder = field.getSortOrder();
                    isDataColumnInverted = dataSortOrder != SortOrder.ASC;
                    isNullable = field.isNullable();
                }
                PDataType indexColumnType = IndexUtil.getIndexColumnDataType(isNullable, dataColumnType);
                boolean isBytesComparable = dataColumnType.isBytesComparableWith(indexColumnType);
                if (isBytesComparable && isDataColumnInverted == descIndexColumnBitSet.get(i)) {
                    output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                } else {
                    if (!isBytesComparable) {
                        indexColumnType.coerceBytes(ptr, dataColumnType, dataSortOrder, SortOrder.getDefault());
                    }
                    if (descIndexColumnBitSet.get(i) != isDataColumnInverted) {
                        IndexMaintainer.writeInverted(ptr.get(), ptr.getOffset(), ptr.getLength(), output);
                    } else {
                        output.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                    }
                }
                if (indexColumnType.isFixedWidth()) continue;
                output.writeByte(0);
            }
            int minLength = length - this.maxTrailingNulls;
            byte[] indexRowKey = stream.getBuffer();
            for (length = stream.size(); length > minLength && indexRowKey[length - 1] == 0; --length) {
            }
            if (this.nIndexSaltBuckets > 0) {
                byte saltByte;
                indexRowKey[0] = saltByte = SaltingUtil.getSaltingByte(indexRowKey, 1, length - 1, this.nIndexSaltBuckets);
            }
            byte[] byArray = indexRowKey.length == length ? indexRowKey : Arrays.copyOf(indexRowKey, length);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, long ts) throws IOException {
        Put put = null;
        if (valueGetter.getLatestValue(this.dataEmptyKeyValueRef) == null) {
            byte[] indexRowKey = this.buildRowKey(valueGetter, dataRowKeyPtr);
            put = new Put(indexRowKey);
            put.add(kvBuilder.buildPut(new ImmutableBytesPtr(indexRowKey), this.getEmptyKeyValueFamily(), QueryConstants.EMPTY_COLUMN_BYTES_PTR, ts, ByteUtil.EMPTY_BYTE_ARRAY_PTR));
            put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        }
        int i = 0;
        for (ColumnReference ref : this.getCoverededColumns()) {
            ImmutableBytesPtr cq = this.indexQualifiers.get(i++);
            ImmutableBytesPtr value = valueGetter.getLatestValue(ref);
            byte[] indexRowKey = this.buildRowKey(valueGetter, dataRowKeyPtr);
            ImmutableBytesPtr rowKey = new ImmutableBytesPtr(indexRowKey);
            if (value == null) continue;
            if (put == null) {
                put = new Put(indexRowKey);
                put.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            put.add(kvBuilder.buildPut(rowKey, ref.getFamilyWritable(), cq, ts, value));
        }
        return put;
    }

    public Put buildUpdateMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr) throws IOException {
        return this.buildUpdateMutation(kvBuilder, valueGetter, dataRowKeyPtr, Long.MAX_VALUE);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter valueGetter, ImmutableBytesWritable dataRowKeyPtr, Collection<KeyValue> pendingUpdates) throws IOException {
        return this.buildDeleteMutation(kvBuilder, valueGetter, dataRowKeyPtr, pendingUpdates, Long.MAX_VALUE);
    }

    public boolean isRowDeleted(Collection<KeyValue> pendingUpdates) {
        int nDeleteCF = 0;
        for (KeyValue kv : pendingUpdates) {
            if (kv.getTypeByte() != KeyValue.Type.DeleteFamily.getCode()) continue;
            ++nDeleteCF;
            boolean isEmptyCF = Bytes.compareTo(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), this.dataEmptyKeyValueCF, 0, this.dataEmptyKeyValueCF.length) == 0;
            if (!isEmptyCF) continue;
            return true;
        }
        return nDeleteCF == this.nDataCFs;
    }

    private boolean hasIndexedColumnChanged(ValueGetter oldState, Collection<KeyValue> pendingUpdates) throws IOException {
        if (pendingUpdates.isEmpty()) {
            return false;
        }
        HashMap<ColumnReference, KeyValue> newState = Maps.newHashMapWithExpectedSize(pendingUpdates.size());
        for (KeyValue kv : pendingUpdates) {
            newState.put(new ColumnReference(CellUtil.cloneFamily(kv), CellUtil.cloneQualifier(kv)), kv);
        }
        for (ColumnReference ref : this.indexedColumns) {
            ImmutableBytesPtr oldValue;
            KeyValue newValue = (KeyValue)newState.get(ref);
            if (newValue == null || (oldValue = oldState.getLatestValue(ref)) != null && Bytes.compareTo(oldValue.get(), oldValue.getOffset(), oldValue.getLength(), newValue.getValueArray(), newValue.getValueOffset(), newValue.getValueLength()) == 0) continue;
            return true;
        }
        return false;
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ImmutableBytesWritable dataRowKeyPtr, long ts) throws IOException {
        return this.buildDeleteMutation(kvBuilder, null, dataRowKeyPtr, Collections.<KeyValue>emptyList(), ts);
    }

    public Delete buildDeleteMutation(KeyValueBuilder kvBuilder, ValueGetter oldState, ImmutableBytesWritable dataRowKeyPtr, Collection<KeyValue> pendingUpdates, long ts) throws IOException {
        byte[] indexRowKey = this.buildRowKey(oldState, dataRowKeyPtr);
        if (oldState == null || this.isRowDeleted(pendingUpdates) || this.hasIndexedColumnChanged(oldState, pendingUpdates)) {
            Delete delete = new Delete(indexRowKey, ts);
            delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            return delete;
        }
        Delete delete = null;
        for (KeyValue kv : pendingUpdates) {
            ColumnReference ref;
            if (kv.getTypeByte() == KeyValue.Type.Put.getCode() || !this.coveredColumns.contains(ref = new ColumnReference(kv.getFamily(), kv.getQualifier()))) continue;
            if (delete == null) {
                delete = new Delete(indexRowKey);
                delete.setDurability(!this.indexWALDisabled ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            }
            delete.deleteColumns(ref.getFamily(), IndexUtil.getIndexColumnName(ref.getFamily(), ref.getQualifier()), ts);
        }
        return delete;
    }

    public byte[] getIndexTableName() {
        return this.indexTableName;
    }

    public Set<ColumnReference> getCoverededColumns() {
        return this.coveredColumns;
    }

    public Set<ColumnReference> getIndexedColumns() {
        return this.indexedColumns;
    }

    public Set<ColumnReference> getAllColumns() {
        return this.allColumns;
    }

    private ImmutableBytesPtr getEmptyKeyValueFamily() {
        return this.emptyKeyValueCFPtr;
    }

    private RowKeyMetaData getRowKeyMetaData() {
        return this.rowKeyMetaData;
    }

    private List<PDataType> getIndexedColumnTypes() {
        return this.indexedColumnTypes;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int i;
        boolean hasViewIndexId;
        int encodedIndexSaltBucketsAndMultiTenant = WritableUtils.readVInt(input);
        this.isMultiTenant = encodedIndexSaltBucketsAndMultiTenant < 0;
        this.nIndexSaltBuckets = Math.abs(encodedIndexSaltBucketsAndMultiTenant) - 1;
        int encodedIndexedColumnsAndViewId = WritableUtils.readVInt(input);
        boolean bl = hasViewIndexId = encodedIndexedColumnsAndViewId < 0;
        if (hasViewIndexId) {
            this.viewIndexId = new byte[MetaDataUtil.getViewIndexIdDataType().getByteSize().intValue()];
            input.readFully(this.viewIndexId);
        }
        int nIndexedColumns = Math.abs(encodedIndexedColumnsAndViewId) - 1;
        this.indexedColumns = Sets.newLinkedHashSetWithExpectedSize(nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            byte[] cf = Bytes.readByteArray(input);
            byte[] cq = Bytes.readByteArray(input);
            this.indexedColumns.add(new ColumnReference(cf, cq));
        }
        this.indexedColumnTypes = Lists.newArrayListWithExpectedSize(nIndexedColumns);
        for (i = 0; i < nIndexedColumns; ++i) {
            PDataType type = PDataType.values()[WritableUtils.readVInt(input)];
            this.indexedColumnTypes.add(type);
        }
        int nCoveredColumns = WritableUtils.readVInt(input);
        this.coveredColumns = Sets.newLinkedHashSetWithExpectedSize(nCoveredColumns);
        for (int i2 = 0; i2 < nCoveredColumns; ++i2) {
            byte[] cf = Bytes.readByteArray(input);
            byte[] cq = Bytes.readByteArray(input);
            this.coveredColumns.add(new ColumnReference(cf, cq));
        }
        this.indexTableName = Bytes.readByteArray(input);
        this.dataEmptyKeyValueCF = Bytes.readByteArray(input);
        this.emptyKeyValueCFPtr = new ImmutableBytesPtr(Bytes.readByteArray(input));
        this.rowKeyMetaData = this.newRowKeyMetaData();
        this.rowKeyMetaData.readFields(input);
        int nDataCFs = WritableUtils.readVInt(input);
        this.indexWALDisabled = nDataCFs < 0;
        this.nDataCFs = Math.abs(nDataCFs) - 1;
        this.estimatedIndexRowKeyBytes = WritableUtils.readVInt(input);
        this.initCachedState();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, (this.nIndexSaltBuckets + 1) * (this.isMultiTenant ? -1 : 1));
        WritableUtils.writeVInt(output, (this.indexedColumns.size() + 1) * (this.viewIndexId != null ? -1 : 1));
        if (this.viewIndexId != null) {
            output.write(this.viewIndexId);
        }
        for (ColumnReference ref : this.indexedColumns) {
            Bytes.writeByteArray(output, ref.getFamily());
            Bytes.writeByteArray(output, ref.getQualifier());
        }
        for (int i = 0; i < this.indexedColumnTypes.size(); ++i) {
            PDataType type = this.indexedColumnTypes.get(i);
            WritableUtils.writeVInt(output, type.ordinal());
        }
        WritableUtils.writeVInt(output, this.coveredColumns.size());
        for (ColumnReference ref : this.coveredColumns) {
            Bytes.writeByteArray(output, ref.getFamily());
            Bytes.writeByteArray(output, ref.getQualifier());
        }
        Bytes.writeByteArray(output, this.indexTableName);
        Bytes.writeByteArray(output, this.dataEmptyKeyValueCF);
        WritableUtils.writeVInt(output, this.emptyKeyValueCFPtr.getLength());
        output.write(this.emptyKeyValueCFPtr.get(), this.emptyKeyValueCFPtr.getOffset(), this.emptyKeyValueCFPtr.getLength());
        this.rowKeyMetaData.write(output);
        WritableUtils.writeVInt(output, (this.nDataCFs + 1) * (this.indexWALDisabled ? -1 : 1));
        WritableUtils.writeVInt(output, this.estimatedIndexRowKeyBytes);
    }

    public int getEstimatedByteSize() {
        int size = WritableUtils.getVIntSize(this.nIndexSaltBuckets);
        size += WritableUtils.getVIntSize(this.estimatedIndexRowKeyBytes);
        size += WritableUtils.getVIntSize(this.indexedColumns.size());
        size += this.viewIndexId == null ? 0 : this.viewIndexId.length;
        for (ColumnReference ref : this.indexedColumns) {
            size += WritableUtils.getVIntSize(ref.getFamily().length);
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize(ref.getQualifier().length);
            size += ref.getQualifier().length;
        }
        size += this.indexedColumnTypes.size();
        size += WritableUtils.getVIntSize(this.coveredColumns.size());
        for (ColumnReference ref : this.coveredColumns) {
            size += WritableUtils.getVIntSize(ref.getFamily().length);
            size += ref.getFamily().length;
            size += WritableUtils.getVIntSize(ref.getQualifier().length);
            size += ref.getQualifier().length;
        }
        size += this.indexTableName.length + WritableUtils.getVIntSize(this.indexTableName.length);
        size += this.rowKeyMetaData.getByteSize();
        size += this.dataEmptyKeyValueCF.length + WritableUtils.getVIntSize(this.dataEmptyKeyValueCF.length);
        size += this.emptyKeyValueCFPtr.getLength() + WritableUtils.getVIntSize(this.emptyKeyValueCFPtr.getLength());
        return size += WritableUtils.getVIntSize(this.nDataCFs + 1);
    }

    private int estimateIndexRowKeyByteSize(int indexColByteSize) {
        int estimatedIndexRowKeyBytes = indexColByteSize + this.dataRowKeySchema.getEstimatedValueLength() + (this.nIndexSaltBuckets == 0 || this.isDataTableSalted ? 0 : 1);
        return estimatedIndexRowKeyBytes;
    }

    private void initCachedState() {
        int indexPkPos;
        this.dataEmptyKeyValueRef = new ColumnReference(this.emptyKeyValueCFPtr.copyBytesIfNecessary(), QueryConstants.EMPTY_COLUMN_BYTES);
        this.indexQualifiers = Lists.newArrayListWithExpectedSize(this.coveredColumns.size());
        for (ColumnReference ref : this.coveredColumns) {
            this.indexQualifiers.add(new ImmutableBytesPtr(IndexUtil.getIndexColumnName(ref.getFamily(), ref.getQualifier())));
        }
        this.allColumns = Sets.newLinkedHashSetWithExpectedSize(this.indexedColumns.size() + this.coveredColumns.size());
        this.allColumns.addAll(this.indexedColumns);
        this.allColumns.addAll(this.coveredColumns);
        int dataPkOffset = (this.isDataTableSalted ? 1 : 0) + (this.isMultiTenant ? 1 : 0);
        int nIndexPkColumns = this.getIndexPkColumnCount();
        this.dataPkPosition = new int[nIndexPkColumns];
        Arrays.fill(this.dataPkPosition, -1);
        BitSet viewConstantColumnBitSet = this.rowKeyMetaData.getViewConstantColumnBitSet();
        for (int i = dataPkOffset; i < this.dataRowKeySchema.getFieldCount(); ++i) {
            if (viewConstantColumnBitSet.get(i)) continue;
            int dataPkPosition = this.rowKeyMetaData.getIndexPkPosition(i - dataPkOffset);
            this.dataPkPosition[dataPkPosition] = i;
        }
        int indexedColumnTypesPos = this.indexedColumnTypes.size() - 1;
        for (indexPkPos = nIndexPkColumns - 1; indexPkPos >= 0; --indexPkPos) {
            PDataType dataType;
            boolean isDataNullable;
            int dataPkPos = this.dataPkPosition[indexPkPos];
            if (dataPkPos == -1) {
                isDataNullable = true;
                dataType = this.indexedColumnTypes.get(indexedColumnTypesPos--);
            } else {
                ValueSchema.Field dataField = this.dataRowKeySchema.getField(dataPkPos);
                dataType = dataField.getDataType();
                isDataNullable = dataField.isNullable();
            }
            PDataType indexDataType = IndexUtil.getIndexColumnDataType(isDataNullable, dataType);
            if (indexDataType.isFixedWidth()) break;
        }
        this.maxTrailingNulls = nIndexPkColumns - indexPkPos - 1;
    }

    private int getIndexPkColumnCount() {
        return this.dataRowKeySchema.getFieldCount() + this.indexedColumns.size() - (this.isDataTableSalted ? 1 : 0) - (this.isMultiTenant ? 1 : 0) - (this.viewIndexId == null ? 0 : 1);
    }

    private RowKeyMetaData newRowKeyMetaData() {
        return this.getIndexPkColumnCount() < 255 ? new ByteSizeRowKeyMetaData() : new IntSizedRowKeyMetaData();
    }

    private RowKeyMetaData newRowKeyMetaData(int capacity) {
        return capacity < 255 ? new ByteSizeRowKeyMetaData(capacity) : new IntSizedRowKeyMetaData(capacity);
    }

    private static void writeInverted(byte[] buf, int offset, int length, DataOutput output) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            byte b = SortOrder.invert(buf[i]);
            output.write(b);
        }
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.allColumns.iterator();
    }

    private class IntSizedRowKeyMetaData
    extends RowKeyMetaData {
        private int[] indexPkPosition;

        private IntSizedRowKeyMetaData() {
        }

        private IntSizedRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new int[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = indexPkPosition;
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                output.writeInt(this.indexPkPosition[i]);
            }
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length * 4;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new int[IndexMaintainer.this.getIndexPkColumnCount()];
            for (int i = 0; i < this.indexPkPosition.length; ++i) {
                this.indexPkPosition[i] = input.readInt();
            }
        }
    }

    private class ByteSizeRowKeyMetaData
    extends RowKeyMetaData {
        private byte[] indexPkPosition;

        private ByteSizeRowKeyMetaData() {
        }

        private ByteSizeRowKeyMetaData(int nIndexedColumns) {
            super(nIndexedColumns);
            this.indexPkPosition = new byte[nIndexedColumns];
        }

        @Override
        protected int getIndexPkPosition(int dataPkPosition) {
            return this.indexPkPosition[dataPkPosition] + BYTE_OFFSET;
        }

        @Override
        protected int setIndexPkPosition(int dataPkPosition, int indexPkPosition) {
            this.indexPkPosition[dataPkPosition] = (byte)(indexPkPosition - BYTE_OFFSET);
            return this.indexPkPosition[dataPkPosition];
        }

        @Override
        public void write(DataOutput output) throws IOException {
            super.write(output);
            output.write(this.indexPkPosition);
        }

        @Override
        protected int getByteSize() {
            return super.getByteSize() + this.indexPkPosition.length;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            super.readFields(input);
            this.indexPkPosition = new byte[IndexMaintainer.this.getIndexPkColumnCount()];
            input.readFully(this.indexPkPosition);
        }
    }

    private abstract class RowKeyMetaData
    implements Writable {
        private BitSet descIndexColumnBitSet;
        private BitSet viewConstantColumnBitSet;

        private RowKeyMetaData() {
        }

        private RowKeyMetaData(int nIndexedColumns) {
            this.descIndexColumnBitSet = BitSet.withCapacity(nIndexedColumns);
            this.viewConstantColumnBitSet = BitSet.withCapacity(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected int getByteSize() {
            return BitSet.getByteSize(IndexMaintainer.this.getIndexPkColumnCount()) * 3 + BitSet.getByteSize(IndexMaintainer.this.dataRowKeySchema.getMaxFields());
        }

        protected abstract int getIndexPkPosition(int var1);

        protected abstract int setIndexPkPosition(int var1, int var2);

        @Override
        public void readFields(DataInput input) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            this.descIndexColumnBitSet = BitSet.read(input, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            this.viewConstantColumnBitSet = BitSet.read(input, vclength);
        }

        @Override
        public void write(DataOutput output) throws IOException {
            int length = IndexMaintainer.this.getIndexPkColumnCount();
            BitSet.write(output, this.descIndexColumnBitSet, length);
            int vclength = IndexMaintainer.this.dataRowKeySchema.getMaxFields();
            BitSet.write(output, this.viewConstantColumnBitSet, vclength);
        }

        private BitSet getDescIndexColumnBitSet() {
            return this.descIndexColumnBitSet;
        }

        private BitSet getViewConstantColumnBitSet() {
            return this.viewConstantColumnBitSet;
        }
    }
}

