/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.index.IndexMetaDataCacheFactory;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;

public class IndexMetaDataCacheClient {
    private final ServerCacheClient serverCache;
    private TableRef cacheUsingTableRef;

    public IndexMetaDataCacheClient(PhoenixConnection connection, TableRef cacheUsingTableRef) {
        this.serverCache = new ServerCacheClient(connection);
        this.cacheUsingTableRef = cacheUsingTableRef;
    }

    public static boolean useIndexMetadataCache(PhoenixConnection connection, List<Mutation> mutations, int indexMetaDataByteLength) {
        ReadOnlyProps props = connection.getQueryServices().getProps();
        int threshold = props.getInt("phoenix.index.mutableBatchSizeThreshold", 5);
        return indexMetaDataByteLength > 8 && mutations.size() > threshold;
    }

    public ServerCacheClient.ServerCache addIndexMetadataCache(List<Mutation> mutations, ImmutableBytesWritable ptr) throws SQLException {
        return this.serverCache.addServerCache(ScanUtil.newScanRanges(mutations), ptr, new IndexMetaDataCacheFactory(), this.cacheUsingTableRef);
    }

    public ServerCacheClient.ServerCache addIndexMetadataCache(ScanRanges ranges, ImmutableBytesWritable ptr) throws SQLException {
        return this.serverCache.addServerCache(ranges, ptr, new IndexMetaDataCacheFactory(), this.cacheUsingTableRef);
    }
}

