/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.hbase.index.covered.CoveredColumnsIndexBuilder;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixIndexBuilder
extends CoveredColumnsIndexBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchStarted(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        ArrayList<KeyRange> keys = Lists.newArrayListWithExpectedSize(miniBatchOp.size());
        ArrayList<IndexMaintainer> maintainers = new ArrayList<IndexMaintainer>();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            keys.add(PDataType.VARBINARY.getKeyRange(m.getRow()));
            maintainers.addAll(this.getCodec().getIndexMaintainers(m.getAttributesMap()));
        }
        Scan scan = IndexManagementUtil.newLocalStateScan(maintainers);
        ScanRanges scanRanges = ScanRanges.create(Collections.singletonList(keys), SchemaUtil.VAR_BINARY_SCHEMA);
        scanRanges.setScanStartStopRow(scan);
        scan.setFilter(scanRanges.getSkipScanFilter());
        HRegion region = this.env.getRegion();
        RegionScanner scanner = region.getScanner(scan);
        region.startRegionOperation();
        try {
            ArrayList<Cell> results;
            boolean hasMore;
            while (hasMore = scanner.nextRaw(results = Lists.newArrayList())) {
            }
        }
        finally {
            try {
                scanner.close();
            }
            finally {
                region.closeRegionOperation();
            }
        }
    }

    private PhoenixIndexCodec getCodec() {
        return (PhoenixIndexCodec)this.codec;
    }

    @Override
    public byte[] getBatchId(Mutation m) {
        return this.codec.getBatchId(m);
    }
}

