/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;

public class ConcatResultIterator
implements PeekingResultIterator {
    private final ResultIterators resultIterators;
    private List<PeekingResultIterator> iterators;
    private int index;

    public ConcatResultIterator(ResultIterators iterators) {
        this.resultIterators = iterators;
    }

    private List<PeekingResultIterator> getIterators() throws SQLException {
        if (this.iterators == null) {
            this.iterators = this.resultIterators.getIterators();
        }
        return this.iterators;
    }

    @Override
    public void close() throws SQLException {
        if (this.iterators != null) {
            while (this.index < this.iterators.size()) {
                PeekingResultIterator iterator = this.iterators.get(this.index);
                iterator.close();
                ++this.index;
            }
        }
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterators.explain(planSteps);
    }

    private PeekingResultIterator currentIterator() throws SQLException {
        List<PeekingResultIterator> iterators = this.getIterators();
        while (this.index < iterators.size()) {
            PeekingResultIterator iterator = iterators.get(this.index);
            Tuple r = iterator.peek();
            if (r != null) {
                return iterator;
            }
            iterator.close();
            ++this.index;
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.currentIterator().peek();
    }

    @Override
    public Tuple next() throws SQLException {
        return this.currentIterator().next();
    }
}

