/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelIteratorRegionSplitter;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.StatsManager;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ReadOnlyProps;

public class DefaultParallelIteratorRegionSplitter
implements ParallelIteratorRegionSplitter {
    protected final int targetConcurrency;
    protected final int maxConcurrency;
    protected final int maxIntraRegionParallelization;
    protected final StatementContext context;
    protected final TableRef tableRef;

    public static DefaultParallelIteratorRegionSplitter getInstance(StatementContext context, TableRef table, HintNode hintNode) {
        return new DefaultParallelIteratorRegionSplitter(context, table, hintNode);
    }

    protected DefaultParallelIteratorRegionSplitter(StatementContext context, TableRef table, HintNode hintNode) {
        this.context = context;
        this.tableRef = table;
        ReadOnlyProps props = context.getConnection().getQueryServices().getProps();
        this.targetConcurrency = props.getInt("phoenix.query.targetConcurrency", 32);
        this.maxConcurrency = props.getInt("phoenix.query.maxConcurrency", 64);
        Preconditions.checkArgument(this.targetConcurrency >= 1, "Invalid target concurrency: " + this.targetConcurrency);
        Preconditions.checkArgument(this.maxConcurrency >= this.targetConcurrency, "Invalid max concurrency: " + this.maxConcurrency);
        this.maxIntraRegionParallelization = hintNode.hasHint(HintNode.Hint.NO_INTRA_REGION_PARALLELIZATION) ? 1 : props.getInt("phoenix.query.maxIntraRegionParallelization", 64);
        Preconditions.checkArgument(this.maxIntraRegionParallelization >= 1, "Invalid max intra region parallelization: " + this.maxIntraRegionParallelization);
    }

    protected List<HRegionLocation> getAllRegions() throws SQLException {
        Scan scan = this.context.getScan();
        PTable table = this.tableRef.getTable();
        List<HRegionLocation> allTableRegions = this.context.getConnection().getQueryServices().getAllTableRegions(table.getPhysicalName().getBytes());
        return DefaultParallelIteratorRegionSplitter.filterRegions(allTableRegions, scan.getStartRow(), scan.getStopRow());
    }

    public static List<HRegionLocation> filterRegions(List<HRegionLocation> allTableRegions, byte[] startKey, byte[] stopKey) {
        final KeyRange keyRange = KeyRange.getKeyRange(startKey, true, stopKey, false);
        if (keyRange == KeyRange.EVERYTHING_RANGE) {
            return allTableRegions;
        }
        Iterable<HRegionLocation> regions = Iterables.filter(allTableRegions, new Predicate<HRegionLocation>(){

            @Override
            public boolean apply(HRegionLocation location) {
                KeyRange regionKeyRange = KeyRange.getKeyRange(location.getRegionInfo().getStartKey(), location.getRegionInfo().getEndKey());
                return keyRange.intersect(regionKeyRange) != KeyRange.EMPTY_RANGE;
            }
        });
        return Lists.newArrayList(regions);
    }

    protected List<KeyRange> genKeyRanges(List<HRegionLocation> regions) {
        boolean done;
        if (regions.isEmpty()) {
            return Collections.emptyList();
        }
        StatsManager statsManager = this.context.getConnection().getQueryServices().getStatsManager();
        int splitsPerRegion = regions.size() >= this.targetConcurrency ? 1 : (regions.size() > this.targetConcurrency / 2 ? this.maxConcurrency : this.targetConcurrency) / regions.size();
        splitsPerRegion = Math.min(splitsPerRegion, this.maxIntraRegionParallelization);
        ArrayListMultimap<HRegionLocation, KeyRange> keyRangesPerRegion = ArrayListMultimap.create(regions.size(), regions.size() * splitsPerRegion);
        if (splitsPerRegion == 1) {
            for (HRegionLocation region : regions) {
                keyRangesPerRegion.put(region, ParallelIterators.TO_KEY_RANGE.apply(region));
            }
        } else {
            for (HRegionLocation region : regions) {
                boolean upperUnbound;
                byte[] startKey = region.getRegionInfo().getStartKey();
                byte[] stopKey = region.getRegionInfo().getEndKey();
                boolean lowerUnbound = Bytes.compareTo(startKey, HConstants.EMPTY_START_ROW) == 0;
                boolean bl = upperUnbound = Bytes.compareTo(stopKey, HConstants.EMPTY_END_ROW) == 0;
                if (lowerUnbound && (startKey = statsManager.getMinKey(this.tableRef)) == null) {
                    keyRangesPerRegion.put(region, ParallelIterators.TO_KEY_RANGE.apply(region));
                    continue;
                }
                if (upperUnbound && (stopKey = statsManager.getMaxKey(this.tableRef)) == null) {
                    keyRangesPerRegion.put(region, ParallelIterators.TO_KEY_RANGE.apply(region));
                    continue;
                }
                byte[][] boundaries = null;
                if (Bytes.compareTo(startKey, stopKey) >= 0 || (boundaries = Bytes.split(startKey, stopKey, splitsPerRegion - 1)) == null) {
                    keyRangesPerRegion.put(region, ParallelIterators.TO_KEY_RANGE.apply(region));
                    continue;
                }
                keyRangesPerRegion.put(region, KeyRange.getKeyRange(lowerUnbound ? KeyRange.UNBOUND : boundaries[0], boundaries[1]));
                if (boundaries.length <= 1) continue;
                for (int i = 1; i < boundaries.length - 2; ++i) {
                    keyRangesPerRegion.put(region, KeyRange.getKeyRange(boundaries[i], true, boundaries[i + 1], false));
                }
                keyRangesPerRegion.put(region, KeyRange.getKeyRange(boundaries[boundaries.length - 2], true, upperUnbound ? KeyRange.UNBOUND : boundaries[boundaries.length - 1], false));
            }
        }
        ArrayList<KeyRange> splits = Lists.newArrayListWithCapacity(regions.size() * splitsPerRegion);
        Collection values = keyRangesPerRegion.asMap().values();
        ArrayList keyRangesList = Lists.newArrayList(values);
        Collections.shuffle(keyRangesList);
        int i = 0;
        do {
            done = true;
            for (int j = 0; j < keyRangesList.size(); ++j) {
                List keyRanges = (List)keyRangesList.get(j);
                if (i >= keyRanges.size()) continue;
                splits.add((KeyRange)keyRanges.get(i));
                done = false;
            }
            ++i;
        } while (!done);
        return splits;
    }

    @Override
    public List<KeyRange> getSplits() throws SQLException {
        return this.genKeyRanges(this.getAllRegions());
    }
}

