/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.Iterators;
import java.text.Format;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.StringUtil;

public abstract class ExplainTable {
    private static final List<KeyRange> EVERYTHING = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    protected final StatementContext context;
    protected final TableRef tableRef;
    protected final GroupByCompiler.GroupBy groupBy;

    public ExplainTable(StatementContext context, TableRef table) {
        this(context, table, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
    }

    public ExplainTable(StatementContext context, TableRef table, GroupByCompiler.GroupBy groupBy) {
        this.context = context;
        this.tableRef = table;
        this.groupBy = groupBy;
    }

    private boolean explainSkipScan(StringBuilder buf) {
        ScanRanges scanRanges = this.context.getScanRanges();
        if (scanRanges.isPointLookup()) {
            int keyCount = scanRanges.getPointLookupCount();
            buf.append("POINT LOOKUP ON " + keyCount + " KEY" + (keyCount > 1 ? "S " : " "));
        } else if (scanRanges.useSkipScanFilter()) {
            buf.append("SKIP SCAN ");
            int count = 1;
            boolean hasRanges = false;
            for (List<KeyRange> ranges : scanRanges.getRanges()) {
                count *= ranges.size();
                for (KeyRange range : ranges) {
                    hasRanges |= !range.isSingleKey();
                }
            }
            buf.append("ON ");
            buf.append(count);
            buf.append(hasRanges ? " RANGE" : " KEY");
            buf.append(count > 1 ? "S " : " ");
        } else {
            buf.append("RANGE SCAN ");
        }
        return scanRanges.useSkipScanFilter();
    }

    protected void explain(String prefix, List<String> planSteps) {
        StringBuilder buf = new StringBuilder(prefix);
        ScanRanges scanRanges = this.context.getScanRanges();
        boolean hasSkipScanFilter = false;
        if (scanRanges.isEverything()) {
            buf.append("FULL SCAN ");
        } else {
            hasSkipScanFilter = this.explainSkipScan(buf);
        }
        buf.append("OVER " + this.tableRef.getTable().getPhysicalName().getString());
        if (!scanRanges.isPointLookup()) {
            this.appendKeyRanges(buf);
        }
        planSteps.add(buf.toString());
        Scan scan = this.context.getScan();
        Filter filter = scan.getFilter();
        PageFilter pageFilter = null;
        if (filter != null) {
            int offset = 0;
            boolean hasFirstKeyOnlyFilter = false;
            String filterDesc = "";
            if (hasSkipScanFilter) {
                if (filter instanceof FilterList) {
                    List<Filter> filterList = ((FilterList)filter).getFilters();
                    if (filterList.get(0) instanceof FirstKeyOnlyFilter) {
                        hasFirstKeyOnlyFilter = true;
                        offset = 1;
                    }
                    if (filterList.size() > offset + 1) {
                        filterDesc = filterList.get(offset + 1).toString();
                        pageFilter = this.getPageFilter(filterList);
                    }
                }
            } else if (filter instanceof FilterList) {
                List<Filter> filterList = ((FilterList)filter).getFilters();
                if (filterList.get(0) instanceof FirstKeyOnlyFilter) {
                    hasFirstKeyOnlyFilter = true;
                    offset = 1;
                }
                if (filterList.size() > offset) {
                    filterDesc = filterList.get(offset).toString();
                    pageFilter = this.getPageFilter(filterList);
                }
            } else if (filter instanceof FirstKeyOnlyFilter) {
                hasFirstKeyOnlyFilter = true;
            } else {
                filterDesc = filter.toString();
            }
            if (filterDesc.length() > 0) {
                planSteps.add("    SERVER FILTER BY " + (hasFirstKeyOnlyFilter ? "FIRST KEY ONLY AND " : "") + filterDesc);
            } else if (hasFirstKeyOnlyFilter) {
                planSteps.add("    SERVER FILTER BY FIRST KEY ONLY");
            }
            if (pageFilter != null) {
                planSteps.add("    SERVER " + pageFilter.getPageSize() + " ROW LIMIT");
            }
        }
        Integer groupByLimit = null;
        byte[] groupByLimitBytes = scan.getAttribute("_GroupByLimit");
        if (groupByLimitBytes != null) {
            groupByLimit = (Integer)PDataType.INTEGER.toObject(groupByLimitBytes);
        }
        this.groupBy.explain(planSteps, groupByLimit);
    }

    private PageFilter getPageFilter(List<Filter> filterList) {
        for (Filter filter : filterList) {
            if (!(filter instanceof PageFilter)) continue;
            return (PageFilter)filter;
        }
        return null;
    }

    private void appendPKColumnValue(StringBuilder buf, byte[] range, Boolean isNull, int slotIndex) {
        if (Boolean.TRUE.equals(isNull)) {
            buf.append("null");
            return;
        }
        if (Boolean.FALSE.equals(isNull)) {
            buf.append("not null");
            return;
        }
        if (range.length == 0) {
            buf.append('*');
            return;
        }
        ScanRanges scanRanges = this.context.getScanRanges();
        PDataType type = scanRanges.getSchema().getField(slotIndex).getDataType();
        SortOrder sortOrder = this.tableRef.getTable().getPKColumns().get(slotIndex).getSortOrder();
        if (sortOrder == SortOrder.DESC) {
            buf.append('~');
            range = SortOrder.invert(range, 0, new byte[range.length], 0, range.length);
        }
        Format formatter = this.context.getConnection().getFormatter(type);
        buf.append(type.toStringLiteral(range, formatter));
    }

    private void appendScanRow(StringBuilder buf, KeyRange.Bound bound) {
        ScanRanges scanRanges = this.context.getScanRanges();
        KeyRange minMaxRange = this.context.getMinMaxRange();
        Iterator<Object> minMaxIterator = Iterators.emptyIterator();
        if (minMaxRange != null) {
            RowKeySchema schema = this.tableRef.getTable().getRowKeySchema();
            if (!minMaxRange.isUnbound(bound)) {
                minMaxIterator = new RowKeyValueIterator(schema, minMaxRange.getRange(bound));
            }
        }
        int nRanges = scanRanges.getRanges().size();
        int i = 0;
        int minPos = 0;
        while (minPos < nRanges || minMaxIterator.hasNext()) {
            Boolean isNull;
            List<KeyRange> ranges = minPos >= nRanges ? EVERYTHING : scanRanges.getRanges().get(minPos++);
            KeyRange range = bound == KeyRange.Bound.LOWER ? ranges.get(0) : ranges.get(ranges.size() - 1);
            byte[] b = range.getRange(bound);
            Boolean bl = KeyRange.IS_NULL_RANGE == range ? Boolean.TRUE : (isNull = KeyRange.IS_NOT_NULL_RANGE == range ? Boolean.FALSE : null);
            if (minMaxIterator.hasNext()) {
                byte[] bMinMax = (byte[])minMaxIterator.next();
                int cmp = Bytes.compareTo(bMinMax, b) * (bound == KeyRange.Bound.LOWER ? 1 : -1);
                if (cmp > 0) {
                    minPos = nRanges;
                    b = bMinMax;
                    isNull = null;
                } else if (cmp < 0) {
                    minMaxIterator = Iterators.emptyIterator();
                }
            }
            this.appendPKColumnValue(buf, b, isNull, i);
            buf.append(',');
            ++i;
        }
    }

    private void appendKeyRanges(StringBuilder buf) {
        ScanRanges scanRanges = this.context.getScanRanges();
        KeyRange minMaxRange = this.context.getMinMaxRange();
        if (minMaxRange == null && (scanRanges == ScanRanges.EVERYTHING || scanRanges == ScanRanges.NOTHING)) {
            return;
        }
        buf.append(" [");
        StringBuilder buf1 = new StringBuilder();
        this.appendScanRow(buf1, KeyRange.Bound.LOWER);
        buf.append((CharSequence)buf1);
        buf.setCharAt(buf.length() - 1, ']');
        StringBuilder buf2 = new StringBuilder();
        this.appendScanRow(buf2, KeyRange.Bound.UPPER);
        if (!StringUtil.equals(buf1, buf2)) {
            buf.append(" - [");
            buf.append((CharSequence)buf2);
        }
        buf.setCharAt(buf.length() - 1, ']');
    }

    private static class RowKeyValueIterator
    implements Iterator<byte[]> {
        private final RowKeySchema schema;
        private ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        private int position = 0;
        private final int maxOffset;
        private byte[] nextValue;

        public RowKeyValueIterator(RowKeySchema schema, byte[] rowKey) {
            this.schema = schema;
            this.maxOffset = schema.iterator(rowKey, this.ptr);
            this.iterate();
        }

        private void iterate() {
            this.nextValue = (byte[])(this.schema.next(this.ptr, this.position++, this.maxOffset) == null ? null : this.ptr.copyBytes());
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public byte[] next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            byte[] value = this.nextValue;
            this.iterate();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

