/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public class FilterAggregatingResultIterator
implements AggregatingResultIterator {
    private final AggregatingResultIterator delegate;
    private final Expression expression;
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();

    public FilterAggregatingResultIterator(AggregatingResultIterator delegate, Expression expression) {
        this.delegate = delegate;
        this.expression = expression;
        if (expression.getDataType() != PDataType.BOOLEAN) {
            throw new IllegalArgumentException("FilterResultIterator requires a boolean expression, but got " + expression);
        }
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple next;
        while ((next = this.delegate.next()) != null && this.expression.evaluate(next, this.ptr) && Boolean.FALSE.equals(this.expression.getDataType().toObject(this.ptr))) {
        }
        return next;
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public void aggregate(Tuple result) {
        this.delegate.aggregate(result);
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT FILTER BY " + this.expression.toString());
    }
}

