/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.TupleUtil;

public class GroupedAggregatingResultIterator
implements AggregatingResultIterator {
    private final ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
    private final PeekingResultIterator resultIterator;
    protected final Aggregators aggregators;

    public GroupedAggregatingResultIterator(PeekingResultIterator resultIterator, Aggregators aggregators) {
        if (resultIterator == null) {
            throw new NullPointerException();
        }
        if (aggregators == null) {
            throw new NullPointerException();
        }
        this.resultIterator = resultIterator;
        this.aggregators = aggregators;
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple result = this.resultIterator.next();
        if (result == null) {
            return null;
        }
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        while (true) {
            this.aggregators.aggregate(rowAggregators, result);
            Tuple nextResult = this.resultIterator.peek();
            if (nextResult == null || !TupleUtil.equals(result, nextResult, this.tempPtr)) break;
            result = this.resultIterator.next();
        }
        byte[] value = this.aggregators.toBytes(rowAggregators);
        result.getKey(this.tempPtr);
        return new SingleKeyValueTuple(KeyValueUtil.newKeyValue(this.tempPtr, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length));
    }

    @Override
    public void close() throws SQLException {
        this.resultIterator.close();
    }

    @Override
    public void aggregate(Tuple result) {
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        this.aggregators.aggregate(rowAggregators, result);
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterator.explain(planSteps);
    }
}

