/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ResultUtil;

public class MappedByteBufferSortedQueue
extends AbstractQueue<OrderedResultIterator.ResultEntry> {
    private Comparator<OrderedResultIterator.ResultEntry> comparator;
    private final int limit;
    private final int thresholdBytes;
    private List<MappedByteBufferPriorityQueue> queues = new ArrayList<MappedByteBufferPriorityQueue>();
    private MappedByteBufferPriorityQueue currentQueue = null;
    private int currentIndex = 0;
    MinMaxPriorityQueue<IndexedResultEntry> mergedQueue = null;

    public MappedByteBufferSortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, int thresholdBytes) throws IOException {
        this.comparator = comparator;
        this.limit = limit == null ? -1 : limit;
        this.thresholdBytes = thresholdBytes;
        this.currentQueue = new MappedByteBufferPriorityQueue(0, this.limit, thresholdBytes, comparator);
        this.queues.add(this.currentQueue);
    }

    @Override
    public boolean offer(OrderedResultIterator.ResultEntry e) {
        try {
            boolean isFlush = this.currentQueue.writeResult(e);
            if (isFlush) {
                ++this.currentIndex;
                this.currentQueue = new MappedByteBufferPriorityQueue(this.currentIndex, this.limit, this.thresholdBytes, this.comparator);
                this.queues.add(this.currentQueue);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return true;
    }

    @Override
    public OrderedResultIterator.ResultEntry poll() {
        IndexedResultEntry re;
        if (this.mergedQueue == null) {
            this.mergedQueue = MinMaxPriorityQueue.orderedBy(this.comparator).maximumSize(this.queues.size()).create();
            for (MappedByteBufferPriorityQueue queue : this.queues) {
                try {
                    IndexedResultEntry next = queue.getNextResult();
                    if (next == null) continue;
                    this.mergedQueue.add(next);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.mergedQueue.isEmpty() && (re = this.mergedQueue.pollFirst()) != null) {
            IndexedResultEntry next = null;
            try {
                next = this.queues.get(re.getIndex()).getNextResult();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (next != null) {
                this.mergedQueue.add(next);
            }
            return re;
        }
        return null;
    }

    @Override
    public OrderedResultIterator.ResultEntry peek() {
        IndexedResultEntry re;
        if (this.mergedQueue == null) {
            this.mergedQueue = MinMaxPriorityQueue.orderedBy(this.comparator).maximumSize(this.queues.size()).create();
            for (MappedByteBufferPriorityQueue queue : this.queues) {
                try {
                    IndexedResultEntry next = queue.getNextResult();
                    if (next == null) continue;
                    this.mergedQueue.add(next);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.mergedQueue.isEmpty() && (re = this.mergedQueue.peekFirst()) != null) {
            return re;
        }
        return null;
    }

    @Override
    public Iterator<OrderedResultIterator.ResultEntry> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (MappedByteBufferPriorityQueue queue : this.queues) {
            size += queue.size();
        }
        return size;
    }

    public long getByteSize() {
        return this.currentQueue.getInMemByteSize();
    }

    public void close() {
        if (this.queues != null) {
            for (MappedByteBufferPriorityQueue queue : this.queues) {
                queue.close();
            }
        }
    }

    private static class MappedByteBufferPriorityQueue {
        private static final long DEFAULT_MAPPING_SIZE = 1024L;
        private final int limit;
        private final int thresholdBytes;
        private long totalResultSize = 0L;
        private int maxResultSize = 0;
        private long mappingSize = 0L;
        private long writeIndex = 0L;
        private long readIndex = 0L;
        private MappedByteBuffer writeBuffer;
        private MappedByteBuffer readBuffer;
        private FileChannel fc;
        private RandomAccessFile af;
        private File file;
        private boolean isClosed = false;
        MinMaxPriorityQueue<OrderedResultIterator.ResultEntry> results = null;
        private boolean flushBuffer = false;
        private int index;
        private int flushedCount;

        public MappedByteBufferPriorityQueue(int index, int limit, int thresholdBytes, Comparator<OrderedResultIterator.ResultEntry> comparator) throws IOException {
            this.index = index;
            this.limit = limit;
            this.thresholdBytes = thresholdBytes;
            this.results = limit < 0 ? MinMaxPriorityQueue.orderedBy(comparator).create() : MinMaxPriorityQueue.orderedBy(comparator).maximumSize(limit).create();
        }

        public int size() {
            if (this.flushBuffer) {
                return this.flushedCount;
            }
            return this.results.size();
        }

        public long getInMemByteSize() {
            if (this.flushBuffer) {
                return 0L;
            }
            return this.totalResultSize;
        }

        private List<KeyValue> toKeyValues(OrderedResultIterator.ResultEntry entry) {
            Tuple result = entry.getResult();
            int size = result.size();
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(size);
            for (int i = 0; i < size; ++i) {
                kvs.add(KeyValueUtil.ensureKeyValue(result.getValue(i)));
            }
            return kvs;
        }

        private int sizeof(List<KeyValue> kvs) {
            int size = 4;
            for (KeyValue kv : kvs) {
                size += kv.getLength();
                size += 4;
            }
            return size;
        }

        private int sizeof(ImmutableBytesWritable[] sortKeys) {
            int size = 4;
            if (sortKeys != null) {
                for (ImmutableBytesWritable sortKey : sortKeys) {
                    if (sortKey != null) {
                        size += sortKey.getLength();
                    }
                    size += 4;
                }
            }
            return size;
        }

        public boolean writeResult(OrderedResultIterator.ResultEntry entry) throws IOException {
            if (this.flushBuffer) {
                throw new IOException("Results already flushed");
            }
            int sortKeySize = this.sizeof(entry.sortKeys);
            int resultSize = this.sizeof(this.toKeyValues(entry)) + sortKeySize;
            boolean added = this.results.add(entry);
            if (added) {
                this.maxResultSize = Math.max(this.maxResultSize, resultSize);
                long l = this.totalResultSize = this.limit < 0 ? this.totalResultSize + (long)resultSize : (long)(this.maxResultSize * this.results.size());
                if (this.totalResultSize >= (long)this.thresholdBytes) {
                    this.file = File.createTempFile(UUID.randomUUID().toString(), null);
                    this.af = new RandomAccessFile(this.file, "rw");
                    this.fc = this.af.getChannel();
                    this.mappingSize = Math.min(Math.max((long)this.maxResultSize, 1024L), this.totalResultSize);
                    this.writeBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, this.writeIndex, this.mappingSize);
                    int resSize = this.results.size();
                    for (int i = 0; i < resSize; ++i) {
                        int totalLen = 0;
                        OrderedResultIterator.ResultEntry re = this.results.pollFirst();
                        List<KeyValue> keyValues = this.toKeyValues(re);
                        for (KeyValue kv : keyValues) {
                            totalLen += kv.getLength() + 4;
                        }
                        this.writeBuffer.putInt(totalLen);
                        for (KeyValue kv : keyValues) {
                            this.writeBuffer.putInt(kv.getLength());
                            this.writeBuffer.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
                        }
                        ImmutableBytesWritable[] sortKeys = re.sortKeys;
                        this.writeBuffer.putInt(sortKeys.length);
                        for (ImmutableBytesWritable sortKey : sortKeys) {
                            if (sortKey != null) {
                                this.writeBuffer.putInt(sortKey.getLength());
                                this.writeBuffer.put(sortKey.get(), sortKey.getOffset(), sortKey.getLength());
                                continue;
                            }
                            this.writeBuffer.putInt(0);
                        }
                        if (this.mappingSize - (long)this.writeBuffer.position() >= (long)this.maxResultSize) continue;
                        this.writeIndex += (long)this.writeBuffer.position();
                        this.writeBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, this.writeIndex, this.mappingSize);
                    }
                    this.writeBuffer.putInt(-1);
                    this.flushedCount = this.results.size();
                    this.results.clear();
                    this.flushBuffer = true;
                }
            }
            return this.flushBuffer;
        }

        public IndexedResultEntry getNextResult() throws IOException {
            int length;
            if (this.isClosed) {
                return null;
            }
            if (!this.flushBuffer) {
                OrderedResultIterator.ResultEntry re = this.results.poll();
                if (re == null) {
                    this.reachedEnd();
                    return null;
                }
                return new IndexedResultEntry(this.index, re);
            }
            if (this.readBuffer == null) {
                this.readBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.readIndex, this.mappingSize);
            }
            if ((length = this.readBuffer.getInt()) < 0) {
                this.reachedEnd();
                return null;
            }
            byte[] rb = new byte[length];
            this.readBuffer.get(rb);
            Result result = ResultUtil.toResult(new ImmutableBytesWritable(rb));
            ResultTuple rt = new ResultTuple(result);
            int sortKeySize = this.readBuffer.getInt();
            ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[sortKeySize];
            for (int i = 0; i < sortKeySize; ++i) {
                int contentLength = this.readBuffer.getInt();
                if (contentLength > 0) {
                    byte[] sortKeyContent = new byte[contentLength];
                    this.readBuffer.get(sortKeyContent);
                    sortKeys[i] = new ImmutableBytesWritable(sortKeyContent);
                    continue;
                }
                sortKeys[i] = null;
            }
            if (this.mappingSize - (long)this.readBuffer.position() < (long)this.maxResultSize) {
                this.readIndex += (long)this.readBuffer.position();
                this.readBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.readIndex, this.mappingSize);
            }
            return new IndexedResultEntry(this.index, new OrderedResultIterator.ResultEntry(sortKeys, rt));
        }

        private void reachedEnd() {
            this.isClosed = true;
            if (this.fc != null) {
                try {
                    this.fc.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this.fc = null;
            }
            if (this.af != null) {
                try {
                    this.af.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.af = null;
            }
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
        }

        public void close() {
            if (!this.isClosed) {
                this.reachedEnd();
            }
        }
    }

    private static class IndexedResultEntry
    extends OrderedResultIterator.ResultEntry {
        private int index;

        public IndexedResultEntry(int index, OrderedResultIterator.ResultEntry resultEntry) {
            super(resultEntry.sortKeys, resultEntry.result);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

