/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SQLCloseables;

public abstract class MergeSortResultIterator
implements PeekingResultIterator {
    protected final ResultIterators resultIterators;
    protected final ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
    private List<PeekingResultIterator> iterators;

    public MergeSortResultIterator(ResultIterators iterators) {
        this.resultIterators = iterators;
    }

    private List<PeekingResultIterator> getIterators() throws SQLException {
        if (this.iterators == null) {
            this.iterators = this.resultIterators.getIterators();
        }
        return this.iterators;
    }

    @Override
    public void close() throws SQLException {
        if (this.iterators != null) {
            SQLCloseables.closeAll(this.iterators);
        }
    }

    protected abstract int compare(Tuple var1, Tuple var2);

    private PeekingResultIterator minIterator() throws SQLException {
        List<PeekingResultIterator> iterators = this.getIterators();
        Tuple minResult = null;
        PeekingResultIterator minIterator = EMPTY_ITERATOR;
        for (int i = iterators.size() - 1; i >= 0; --i) {
            PeekingResultIterator iterator = iterators.get(i);
            Tuple r = iterator.peek();
            if (r != null) {
                if (minResult != null && this.compare(r, minResult) >= 0) continue;
                minResult = r;
                minIterator = iterator;
                continue;
            }
            iterator.close();
            iterators.remove(i);
        }
        return minIterator;
    }

    @Override
    public Tuple peek() throws SQLException {
        PeekingResultIterator iterator = this.minIterator();
        return iterator.peek();
    }

    @Override
    public Tuple next() throws SQLException {
        PeekingResultIterator iterator = this.minIterator();
        return iterator.next();
    }
}

