/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.MappedByteBufferSortedQueue;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class OrderedResultIterator
implements PeekingResultIterator {
    private static final Function<OrderByExpression, Expression> TO_EXPRESSION = new Function<OrderByExpression, Expression>(){

        @Override
        public Expression apply(OrderByExpression column) {
            return column.getExpression();
        }
    };
    private final int thresholdBytes;
    private final Integer limit;
    private final ResultIterator delegate;
    private final List<OrderByExpression> orderByExpressions;
    private final long estimatedByteSize;
    private PeekingResultIterator resultIterator;
    private long byteSize;

    protected ResultIterator getDelegate() {
        return this.delegate;
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes, Integer limit) {
        this(delegate, orderByExpressions, thresholdBytes, limit, 0);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes) throws SQLException {
        this(delegate, orderByExpressions, thresholdBytes, null);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, int thresholdBytes, Integer limit, int estimatedRowSize) {
        Preconditions.checkArgument(!orderByExpressions.isEmpty());
        this.delegate = delegate;
        this.orderByExpressions = orderByExpressions;
        this.thresholdBytes = thresholdBytes;
        this.limit = limit;
        long estimatedEntrySize = 40 + orderByExpressions.size() * 48 + 16 + estimatedRowSize;
        assert (limit == null || Long.MAX_VALUE / estimatedEntrySize >= (long)limit.intValue());
        this.estimatedByteSize = limit == null ? 0L : (long)limit.intValue() * estimatedEntrySize;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public long getEstimatedByteSize() {
        return this.estimatedByteSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    private static Comparator<ResultEntry> buildComparator(List<OrderByExpression> orderByExpressions) {
        Ordering<ResultEntry> ordering = null;
        int pos = 0;
        for (OrderByExpression col : orderByExpressions) {
            Ordering<Object> o = Ordering.from(new ImmutableBytesWritable.Comparator());
            if (!col.isAscending()) {
                o = o.reverse();
            }
            o = col.isNullsLast() ? o.nullsLast() : o.nullsFirst();
            Ordering<ResultEntry> entryOrdering = o.onResultOf(new NthKey(pos++));
            ordering = ordering == null ? entryOrdering : ordering.compound(entryOrdering);
        }
        return ordering;
    }

    @Override
    public Tuple next() throws SQLException {
        return this.getResultIterator().next();
    }

    private PeekingResultIterator getResultIterator() throws SQLException {
        if (this.resultIterator != null) {
            return this.resultIterator;
        }
        int numSortKeys = this.orderByExpressions.size();
        ArrayList<Expression> expressions = Lists.newArrayList(Collections2.transform(this.orderByExpressions, TO_EXPRESSION));
        Comparator<ResultEntry> comparator = OrderedResultIterator.buildComparator(this.orderByExpressions);
        try {
            final MappedByteBufferSortedQueue queueEntries = new MappedByteBufferSortedQueue(comparator, this.limit, this.thresholdBytes);
            this.resultIterator = new PeekingResultIterator(){
                int count = 0;

                @Override
                public Tuple next() throws SQLException {
                    ResultEntry entry = queueEntries.poll();
                    if (entry == null || OrderedResultIterator.this.limit != null && ++this.count > OrderedResultIterator.this.limit) {
                        OrderedResultIterator.this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
                        return null;
                    }
                    return entry.getResult();
                }

                @Override
                public Tuple peek() throws SQLException {
                    if (OrderedResultIterator.this.limit != null && this.count > OrderedResultIterator.this.limit) {
                        return null;
                    }
                    ResultEntry entry = queueEntries.peek();
                    if (entry == null) {
                        return null;
                    }
                    return entry.getResult();
                }

                @Override
                public void explain(List<String> planSteps) {
                }

                @Override
                public void close() throws SQLException {
                    queueEntries.close();
                }
            };
            Tuple result = this.delegate.next();
            while (result != null) {
                int pos = 0;
                ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[numSortKeys];
                for (Expression expression : expressions) {
                    ImmutableBytesWritable sortKey = new ImmutableBytesWritable();
                    boolean evaluated = expression.evaluate(result, sortKey);
                    sortKeys[pos++] = evaluated && sortKey.getLength() > 0 ? sortKey : null;
                }
                queueEntries.add(new ResultEntry(sortKeys, result));
                result = this.delegate.next();
            }
            this.byteSize = queueEntries.getByteSize();
        }
        catch (IOException e) {
            throw new SQLException("", e);
        }
        finally {
            this.delegate.close();
        }
        return this.resultIterator;
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.getResultIterator().peek();
    }

    @Override
    public void close() {
        this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT" + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderByExpressions.toString());
    }

    private static class NthKey
    implements Function<ResultEntry, ImmutableBytesWritable> {
        private final int index;

        NthKey(int index) {
            this.index = index;
        }

        @Override
        public ImmutableBytesWritable apply(ResultEntry entry) {
            return entry.getSortKey(this.index);
        }
    }

    protected static class ResultEntry {
        protected final ImmutableBytesWritable[] sortKeys;
        protected final Tuple result;

        ResultEntry(ImmutableBytesWritable[] sortKeys, Tuple result) {
            this.sortKeys = sortKeys;
            this.result = result;
        }

        ImmutableBytesWritable getSortKey(int index) {
            Preconditions.checkPositionIndex(index, this.sortKeys.length);
            return this.sortKeys[index];
        }

        Tuple getResult() {
            return this.result;
        }
    }
}

