/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Function;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ParallelIteratorRegionSplitterFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelIterators
extends ExplainTable
implements ResultIterators {
    private static final Logger logger = LoggerFactory.getLogger(ParallelIterators.class);
    private final List<KeyRange> splits;
    private final ParallelIteratorFactory iteratorFactory;
    private static final int DEFAULT_THREAD_TIMEOUT_MS = 60000;
    static final Function<HRegionLocation, KeyRange> TO_KEY_RANGE = new Function<HRegionLocation, KeyRange>(){

        @Override
        public KeyRange apply(HRegionLocation region) {
            return KeyRange.getKeyRange(region.getRegionInfo().getStartKey(), region.getRegionInfo().getEndKey());
        }
    };

    public ParallelIterators(StatementContext context, TableRef tableRef, FilterableStatement statement, RowProjector projector, GroupByCompiler.GroupBy groupBy, Integer limit, ParallelIteratorFactory iteratorFactory) throws SQLException {
        PTable table;
        Scan scan;
        block5: {
            block3: {
                Map<byte[], NavigableSet<byte[]>> familyMap;
                block4: {
                    super(context, tableRef, groupBy);
                    this.splits = ParallelIterators.getSplits(context, tableRef, statement.getHint());
                    this.iteratorFactory = iteratorFactory;
                    scan = context.getScan();
                    table = tableRef.getTable();
                    if (!projector.isProjectEmptyKeyValue()) break block3;
                    familyMap = scan.getFamilyMap();
                    if (!familyMap.isEmpty() || !context.getWhereCoditionColumns().isEmpty() || table.getColumnFamilies().size() != 1) break block4;
                    scan.addFamily(table.getColumnFamilies().get(0).getName().getBytes());
                    ScanUtil.andFilterAtBeginning(scan, new FirstKeyOnlyFilter());
                    break block5;
                }
                byte[] ecf = SchemaUtil.getEmptyColumnFamily(table);
                if (familyMap.containsKey(ecf) && familyMap.get(ecf) == null) break block5;
                scan.addColumn(ecf, QueryConstants.EMPTY_COLUMN_BYTES);
                break block5;
            }
            if (table.getViewType() == PTable.ViewType.MAPPED) {
                for (PColumnFamily family : table.getColumnFamilies()) {
                    scan.addFamily(family.getName().getBytes());
                }
            }
        }
        if (limit != null) {
            ScanUtil.andFilterAtEnd(scan, new PageFilter(limit.intValue()));
        }
        this.doColumnProjectionOptimization(context, scan, table, statement);
    }

    private void doColumnProjectionOptimization(StatementContext context, Scan scan, PTable table, FilterableStatement statement) {
        Map<byte[], NavigableSet<byte[]>> familyMap = scan.getFamilyMap();
        if (familyMap != null && !familyMap.isEmpty()) {
            boolean useOptimization;
            TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
            TreeSet<byte[]> conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            int referencedCfCount = familyMap.size();
            for (Pair<byte[], byte[]> whereCol : context.getWhereCoditionColumns()) {
                if (familyMap.containsKey(whereCol.getFirst())) continue;
                ++referencedCfCount;
            }
            if (statement.getHint().hasHint(HintNode.Hint.SEEK_TO_COLUMN)) {
                useOptimization = false;
            } else if (statement.getHint().hasHint(HintNode.Hint.NO_SEEK_TO_COLUMN)) {
                useOptimization = true;
            } else {
                boolean bl = useOptimization = referencedCfCount == 1;
            }
            if (useOptimization) {
                for (Map.Entry entry : familyMap.entrySet()) {
                    ImmutableBytesPtr cf = new ImmutableBytesPtr((byte[])entry.getKey());
                    NavigableSet qs = (NavigableSet)entry.getValue();
                    TreeSet<ImmutableBytesPtr> cols = null;
                    if (qs != null) {
                        cols = new TreeSet<ImmutableBytesPtr>();
                        for (byte[] q : qs) {
                            cols.add(new ImmutableBytesPtr(q));
                        }
                    }
                    columnsTracker.put(cf, cols);
                }
            }
            for (Pair pair : context.getWhereCoditionColumns()) {
                if (useOptimization) {
                    if (familyMap.containsKey(pair.getFirst())) continue;
                    scan.addFamily((byte[])pair.getFirst());
                    conditionOnlyCfs.add((byte[])pair.getFirst());
                    continue;
                }
                if (familyMap.containsKey(pair.getFirst())) {
                    NavigableSet<byte[]> cols = familyMap.get(pair.getFirst());
                    if (cols == null) continue;
                    scan.addColumn((byte[])pair.getFirst(), (byte[])pair.getSecond());
                    continue;
                }
                scan.addColumn((byte[])pair.getFirst(), (byte[])pair.getSecond());
            }
            if (useOptimization && !columnsTracker.isEmpty()) {
                for (ImmutableBytesPtr immutableBytesPtr : columnsTracker.keySet()) {
                    scan.addFamily(immutableBytesPtr.get());
                }
                if (!statement.isAggregate()) {
                    ScanUtil.andFilterAtEnd(scan, new ColumnProjectionFilter(SchemaUtil.getEmptyColumnFamily(table), columnsTracker, conditionOnlyCfs));
                }
            }
        }
    }

    public static List<KeyRange> getSplits(StatementContext context, TableRef table, HintNode hintNode) throws SQLException {
        return ParallelIteratorRegionSplitterFactory.getSplitter(context, table, hintNode).getSplits();
    }

    public List<KeyRange> getSplits() {
        return this.splits;
    }

    @Override
    public List<PeekingResultIterator> getIterators() throws SQLException {
        boolean success = false;
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        ReadOnlyProps props = services.getProps();
        int numSplits = this.splits.size();
        ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(numSplits);
        ArrayList<Pair<byte[], Future<PeekingResultIterator>>> futures = new ArrayList<Pair<byte[], Future<PeekingResultIterator>>>(numSplits);
        final UUID scanId = UUID.randomUUID();
        try {
            ExecutorService executor = services.getExecutor();
            for (KeyRange split : this.splits) {
                KeyRange keyRange;
                final Scan splitScan = new Scan(this.context.getScan());
                if (this.tableRef.getTable().getBucketNum() != null && (keyRange = this.context.getMinMaxRange()) != null) {
                    KeyRange keyRange2 = SaltingUtil.addSaltByte(split.getLowerRange(), keyRange);
                    split = split.intersect(keyRange2);
                }
                if (!ScanUtil.intersectScanRange(splitScan, split.getLowerRange(), split.getUpperRange(), this.context.getScanRanges().useSkipScanFilter())) continue;
                ScanUtil.swapStartStopRowIfReversed(splitScan);
                Future<PeekingResultIterator> future = executor.submit(new JobManager.JobCallable<PeekingResultIterator>(){

                    @Override
                    public PeekingResultIterator call() throws Exception {
                        long startTime = System.currentTimeMillis();
                        TableResultIterator scanner = new TableResultIterator(ParallelIterators.this.context, ParallelIterators.this.tableRef, splitScan);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Id: " + scanId + ", Time: " + (System.currentTimeMillis() - startTime) + "ms, Scan: " + splitScan);
                        }
                        return ParallelIterators.this.iteratorFactory.newIterator(ParallelIterators.this.context, scanner);
                    }

                    @Override
                    public Object getJobId() {
                        return ParallelIterators.this;
                    }
                });
                futures.add(new Pair<byte[], Future<PeekingResultIterator>>(split.getLowerRange(), future));
            }
            int timeoutMs = props.getInt("phoenix.query.timeoutMs", 60000);
            final int factor = ScanUtil.isReversed(this.context.getScan()) ? -1 : 1;
            Collections.sort(futures, new Comparator<Pair<byte[], Future<PeekingResultIterator>>>(){

                @Override
                public int compare(Pair<byte[], Future<PeekingResultIterator>> o1, Pair<byte[], Future<PeekingResultIterator>> o2) {
                    return factor * Bytes.compareTo(o1.getFirst(), o2.getFirst());
                }
            });
            for (Pair pair : futures) {
                iterators.add((PeekingResultIterator)((Future)pair.getSecond()).get(timeoutMs, TimeUnit.MILLISECONDS));
            }
            success = true;
            ArrayList<PeekingResultIterator> arrayList = iterators;
            return arrayList;
        }
        catch (Exception e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            if (!success) {
                SQLCloseables.closeAllQuietly(iterators);
            }
        }
    }

    @Override
    public int size() {
        return this.splits.size();
    }

    @Override
    public void explain(List<String> planSteps) {
        StringBuilder buf = new StringBuilder();
        buf.append("CLIENT PARALLEL " + this.size() + "-WAY ");
        this.explain(buf.toString(), planSteps);
    }

    public static interface ParallelIteratorFactory {
        public PeekingResultIterator newIterator(StatementContext var1, ResultIterator var2) throws SQLException;
    }
}

