/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.phoenix.iterate.BaseResultIterator;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class RegionScannerResultIterator
extends BaseResultIterator {
    private final RegionScanner scanner;

    public RegionScannerResultIterator(RegionScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            ArrayList<Cell> results = new ArrayList<Cell>();
            boolean hasMore = this.scanner.nextRaw(results);
            if (!hasMore && results.isEmpty()) {
                return null;
            }
            MultiKeyValueTuple tuple = new MultiKeyValueTuple();
            tuple.setKeyValues(results);
            return tuple;
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }
}

