/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class ScanningResultIterator
implements ResultIterator {
    private final ResultScanner scanner;

    public ScanningResultIterator(ResultScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void close() throws SQLException {
        this.scanner.close();
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            Result result = this.scanner.next();
            return result == null ? null : new ResultTuple(result);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public void explain(List<String> planSteps) {
    }
}

