/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.DefaultParallelIteratorRegionSplitter;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableRef;

public class SkipRangeParallelIteratorRegionSplitter
extends DefaultParallelIteratorRegionSplitter {
    public static SkipRangeParallelIteratorRegionSplitter getInstance(StatementContext context, TableRef table, HintNode hintNode) {
        return new SkipRangeParallelIteratorRegionSplitter(context, table, hintNode);
    }

    protected SkipRangeParallelIteratorRegionSplitter(StatementContext context, TableRef table, HintNode hintNode) {
        super(context, table, hintNode);
    }

    @Override
    protected List<HRegionLocation> getAllRegions() throws SQLException {
        List<HRegionLocation> allTableRegions = this.context.getConnection().getQueryServices().getAllTableRegions(this.tableRef.getTable().getPhysicalName().getBytes());
        return this.filterRegions(allTableRegions, this.context.getScanRanges());
    }

    public List<HRegionLocation> filterRegions(List<HRegionLocation> allTableRegions, final ScanRanges ranges) {
        if (ranges == ScanRanges.EVERYTHING) {
            return allTableRegions;
        }
        if (ranges == ScanRanges.NOTHING) {
            return Lists.newArrayList();
        }
        Iterable<HRegionLocation> regions = Iterables.filter(allTableRegions, new Predicate<HRegionLocation>(){

            @Override
            public boolean apply(HRegionLocation region) {
                KeyRange minMaxRange = SkipRangeParallelIteratorRegionSplitter.this.context.getMinMaxRange();
                if (minMaxRange != null) {
                    KeyRange range = KeyRange.getKeyRange(region.getRegionInfo().getStartKey(), region.getRegionInfo().getEndKey());
                    if (SkipRangeParallelIteratorRegionSplitter.this.tableRef.getTable().getBucketNum() != null) {
                        minMaxRange = SaltingUtil.addSaltByte(region.getRegionInfo().getStartKey(), minMaxRange);
                    }
                    range = range.intersect(minMaxRange);
                    return ranges.intersect(range.getLowerRange(), range.getUpperRange());
                }
                return ranges.intersect(region.getRegionInfo().getStartKey(), region.getRegionInfo().getEndKey());
            }
        });
        return Lists.newArrayList(regions);
    }
}

