/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ExplainTable;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ServerUtil;

public class TableResultIterator
extends ExplainTable
implements ResultIterator {
    private final HTableInterface htable;
    private final ResultIterator delegate;

    public TableResultIterator(StatementContext context, TableRef tableRef) throws SQLException {
        this(context, tableRef, context.getScan());
    }

    public TableResultIterator(StatementContext context, TableRef tableRef, Scan scan) throws SQLException {
        super(context, tableRef);
        this.htable = context.getConnection().getQueryServices().getTable(tableRef.getTable().getPhysicalName().getBytes());
        try {
            this.delegate = new ScanningResultIterator(this.htable.getScanner(scan));
        }
        catch (IOException e) {
            Closeables.closeQuietly(this.htable);
            throw ServerUtil.parseServerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.delegate.close();
        }
        finally {
            try {
                this.htable.close();
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
    }

    @Override
    public Tuple next() throws SQLException {
        return this.delegate.next();
    }

    @Override
    public void explain(List<String> planSteps) {
        StringBuilder buf = new StringBuilder();
        this.explain(buf.toString(), planSteps);
    }
}

