/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;

public class UngroupedAggregatingResultIterator
extends GroupedAggregatingResultIterator {
    private boolean hasRows = false;

    public UngroupedAggregatingResultIterator(PeekingResultIterator resultIterator, Aggregators aggregators) {
        super(resultIterator, aggregators);
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple result = super.next();
        if (result == null && !this.hasRows) {
            byte[] value = this.aggregators.toBytes(this.aggregators.getAggregators());
            result = new SingleKeyValueTuple(KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value));
        }
        this.hasRows = true;
        return result;
    }
}

