/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.ConnectionlessQueryServicesImpl;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesImpl;
import org.apache.phoenix.util.SQLCloseables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixDriver
extends PhoenixEmbeddedDriver {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixDriver.class);
    public static final PhoenixDriver INSTANCE;
    private final ConcurrentMap<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices> connectionQueryServicesMap = new ConcurrentHashMap<PhoenixEmbeddedDriver.ConnectionInfo, ConnectionQueryServices>(3);
    private volatile QueryServices services;
    private volatile boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryServices getQueryServices() {
        this.checkClosed();
        QueryServices result = this.services;
        if (result == null) {
            PhoenixDriver phoenixDriver = this;
            synchronized (phoenixDriver) {
                result = this.services;
                if (result == null) {
                    this.services = result = new QueryServicesImpl();
                }
            }
        }
        return result;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return super.acceptsURL(url) && !PhoenixDriver.isTestUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConnectionQueryServices getConnectionQueryServices(String url, Properties info) throws SQLException {
        ConnectionQueryServices prevValue;
        this.checkClosed();
        PhoenixEmbeddedDriver.ConnectionInfo connInfo = PhoenixEmbeddedDriver.ConnectionInfo.create(url);
        QueryServices services = this.getQueryServices();
        PhoenixEmbeddedDriver.ConnectionInfo normalizedConnInfo = connInfo.normalize(services.getProps());
        ConnectionQueryServices connectionQueryServices = (ConnectionQueryServices)this.connectionQueryServicesMap.get(normalizedConnInfo);
        if (connectionQueryServices == null && (prevValue = this.connectionQueryServicesMap.putIfAbsent(normalizedConnInfo, connectionQueryServices = normalizedConnInfo.isConnectionless() ? new ConnectionlessQueryServicesImpl(services) : new ConnectionQueryServicesImpl(services, normalizedConnInfo))) != null) {
            connectionQueryServices = prevValue;
        }
        boolean success = false;
        SQLException sqlE = null;
        try {
            connectionQueryServices.init(url, info);
            success = true;
            return connectionQueryServices;
        }
        catch (SQLException e) {
            sqlE = e;
            return sqlE;
        }
        finally {
            if (success) return connectionQueryServices;
            try {
                connectionQueryServices.close();
            }
            catch (SQLException e) {
                if (sqlE == null) {
                    sqlE = e;
                }
                sqlE.setNextException(e);
            }
            finally {
                this.connectionQueryServicesMap.remove(normalizedConnInfo);
                if (sqlE == null) return connectionQueryServices;
                throw sqlE;
            }
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("The Phoenix jdbc driver has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Collection connectionQueryServices = this.connectionQueryServicesMap.values();
        if (!connectionQueryServices.isEmpty()) {
            try {
                try {
                    SQLCloseables.closeAll(connectionQueryServices);
                }
                finally {
                    this.services.getExecutor().shutdownNow();
                }
            }
            finally {
                connectionQueryServices.clear();
            }
        }
        this.services = null;
    }

    static {
        try {
            INSTANCE = new PhoenixDriver();
            DriverManager.registerDriver(INSTANCE);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        INSTANCE.close();
                    }
                    catch (SQLException e) {
                        logger.warn("Unable to close PhoenixDriver on shutdown", e);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to register " + PhoenixDriver.class.getName() + ": " + e.getMessage());
        }
    }
}

