/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.Jdbc7Shim;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SQLCloseable;

public abstract class PhoenixEmbeddedDriver
implements Driver,
Jdbc7Shim.Driver,
SQLCloseable {
    private static final String DNC_JDBC_PROTOCOL_SUFFIX = "//";
    private static final String TERMINATOR = ";";
    private static final String DELIMITERS = ";:";
    private static final String TEST_URL_AT_END = ";test=true";
    private static final String TEST_URL_IN_MIDDLE = ";test=true;";
    private static final DriverPropertyInfo[] EMPTY_INFO = new DriverPropertyInfo[0];
    public static final String MAJOR_VERSION_PROP = "DriverMajorVersion";
    public static final String MINOR_VERSION_PROP = "DriverMinorVersion";
    public static final String DRIVER_NAME_PROP = "DriverName";

    PhoenixEmbeddedDriver() {
    }

    private String getDriverName() {
        return this.getClass().getName();
    }

    public abstract QueryServices getQueryServices();

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.startsWith("jdbc:phoenix")) {
            if (url.length() == "jdbc:phoenix".length()) {
                return true;
            }
            if (';' == url.charAt("jdbc:phoenix".length())) {
                return true;
            }
            if (':' == url.charAt("jdbc:phoenix".length())) {
                int protoLength = "jdbc:phoenix".length() + 1;
                if (url.length() == protoLength) {
                    return true;
                }
                if (!url.startsWith(DNC_JDBC_PROTOCOL_SUFFIX, protoLength)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ConnectionQueryServices connectionServices = this.getConnectionQueryServices(url, info);
        info.setProperty(MAJOR_VERSION_PROP, Integer.toString(this.getMajorVersion()));
        info.setProperty(MINOR_VERSION_PROP, Integer.toString(this.getMinorVersion()));
        info.setProperty(DRIVER_NAME_PROP, this.getDriverName());
        PhoenixConnection connection = connectionServices.connect(url, info);
        return connection;
    }

    protected abstract ConnectionQueryServices getConnectionQueryServices(String var1, Properties var2) throws SQLException;

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_INFO;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public void close() throws SQLException {
    }

    public static boolean isTestUrl(String url) {
        return url.endsWith(TEST_URL_AT_END) || url.contains(TEST_URL_IN_MIDDLE);
    }

    public static class ConnectionInfo {
        private final Integer port;
        private final String rootNode;
        private final String zookeeperQuorum;
        private final boolean isConnectionless;

        protected static ConnectionInfo create(String url) throws SQLException {
            Integer port;
            String[] tokens;
            boolean isMalformedUrl;
            block9: {
                StringTokenizer tokenizer = new StringTokenizer(url == null ? "" : url.substring("jdbc:phoenix".length()), PhoenixEmbeddedDriver.DELIMITERS, true);
                int i = 0;
                isMalformedUrl = false;
                tokens = new String[3];
                String token = null;
                while (tokenizer.hasMoreTokens() && !(token = tokenizer.nextToken()).equals(PhoenixEmbeddedDriver.TERMINATOR) && tokenizer.hasMoreTokens() && i < tokens.length) {
                    token = tokenizer.nextToken();
                    if (PhoenixEmbeddedDriver.DELIMITERS.contains(token)) {
                        isMalformedUrl = true;
                        break;
                    }
                    tokens[i++] = token;
                }
                port = null;
                if (!isMalformedUrl) {
                    if (tokenizer.hasMoreTokens() && !PhoenixEmbeddedDriver.TERMINATOR.equals(token)) {
                        isMalformedUrl = true;
                    } else if (i > 1) {
                        try {
                            port = Integer.parseInt(tokens[1]);
                            isMalformedUrl = port < 0;
                        }
                        catch (NumberFormatException e) {
                            isMalformedUrl = i == 3;
                            if (isMalformedUrl) break block9;
                            tokens[2] = tokens[1];
                        }
                    }
                }
            }
            if (isMalformedUrl) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(url).build().buildException();
            }
            return new ConnectionInfo(tokens[0], port, tokens[2]);
        }

        public ConnectionInfo normalize(ReadOnlyProps props) throws SQLException {
            String zookeeperQuorum = this.getZookeeperQuorum();
            Integer port = this.getPort();
            String rootNode = this.getRootNode();
            if (zookeeperQuorum == null && (zookeeperQuorum = props.get("hbase.zookeeper.quorum")) == null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(this.toString()).build().buildException();
            }
            if (port == null) {
                String portStr;
                if (!this.isConnectionless && (portStr = props.get("hbase.zookeeper.property.clientPort")) != null) {
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage(this.toString()).build().buildException();
                    }
                }
            } else if (this.isConnectionless) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage("Port may not be specified when using the connectionless url \"" + this.toString() + "\"").build().buildException();
            }
            if (rootNode == null) {
                if (!this.isConnectionless) {
                    rootNode = props.get("zookeeper.znode.parent");
                }
            } else if (this.isConnectionless) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.MALFORMED_CONNECTION_URL).setMessage("Root node may not be specified when using the connectionless url \"" + this.toString() + "\"").build().buildException();
            }
            return new ConnectionInfo(zookeeperQuorum, port, rootNode);
        }

        ConnectionInfo(String zookeeperQuorum, Integer port, String rootNode) {
            this.zookeeperQuorum = zookeeperQuorum;
            this.port = port;
            this.rootNode = rootNode;
            this.isConnectionless = "none".equals(zookeeperQuorum);
        }

        public ReadOnlyProps asProps() {
            HashMap<String, String> connectionProps = Maps.newHashMapWithExpectedSize(3);
            if (this.getZookeeperQuorum() != null) {
                connectionProps.put("hbase.zookeeper.quorum", this.getZookeeperQuorum());
            }
            if (this.getPort() != null) {
                connectionProps.put("hbase.zookeeper.property.clientPort", this.getPort().toString());
            }
            if (this.getRootNode() != null) {
                connectionProps.put("zookeeper.znode.parent", this.getRootNode());
            }
            return connectionProps.isEmpty() ? ReadOnlyProps.EMPTY_PROPS : new ReadOnlyProps(connectionProps.entrySet().iterator());
        }

        public boolean isConnectionless() {
            return this.isConnectionless;
        }

        public String getZookeeperQuorum() {
            return this.zookeeperQuorum;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getRootNode() {
            return this.rootNode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.zookeeperQuorum == null ? 0 : this.zookeeperQuorum.hashCode());
            result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
            result = 31 * result + (this.rootNode == null ? 0 : this.rootNode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)obj;
            if (this.zookeeperQuorum == null ? other.zookeeperQuorum != null : !this.zookeeperQuorum.equals(other.zookeeperQuorum)) {
                return false;
            }
            if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
                return false;
            }
            return !(this.rootNode == null ? other.rootNode != null : !this.rootNode.equals(other.rootNode));
        }

        public String toString() {
            return this.zookeeperQuorum + (this.port == null ? "" : ":" + this.port) + (this.rootNode == null ? "" : ":" + this.rootNode);
        }
    }
}

