/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.CreateIndexCompiler;
import org.apache.phoenix.compile.CreateSequenceCompiler;
import org.apache.phoenix.compile.CreateTableCompiler;
import org.apache.phoenix.compile.DeleteCompiler;
import org.apache.phoenix.compile.DropSequenceCompiler;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.StatementPlan;
import org.apache.phoenix.compile.UpsertCompiler;
import org.apache.phoenix.exception.BatchUpdateExecution;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.Jdbc7Shim;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.ExplainStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ExecuteQueryNotApplicableException;
import org.apache.phoenix.schema.ExecuteUpdateNotApplicableException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ServerUtil;

public class PhoenixStatement
implements Statement,
SQLCloseable,
Jdbc7Shim.Statement {
    protected final PhoenixConnection connection;
    private static final int NO_UPDATE = -1;
    private List<PhoenixResultSet> resultSets = new ArrayList<PhoenixResultSet>();
    private QueryPlan lastQueryPlan;
    private PhoenixResultSet lastResultSet;
    private int lastUpdateCount = -1;
    private Operation lastUpdateOperation;
    private boolean isClosed = false;
    private int maxRows;
    private static final byte[] EXPLAIN_PLAN_FAMILY = QueryConstants.SINGLE_COLUMN_FAMILY;
    private static final byte[] EXPLAIN_PLAN_COLUMN = PDataType.VARCHAR.toBytes("Plan");
    private static final String EXPLAIN_PLAN_ALIAS = "PLAN";
    private static final String EXPLAIN_PLAN_TABLE_NAME = "PLAN_TABLE";
    private static final PDatum EXPLAIN_PLAN_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PDataType.VARCHAR;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    private static final RowProjector EXPLAIN_PLAN_ROW_PROJECTOR = new RowProjector(Arrays.asList(new ExpressionProjector("PLAN", "PLAN_TABLE", new RowKeyColumnExpression(EXPLAIN_PLAN_DATUM, new RowKeyValueAccessor(Collections.singletonList(EXPLAIN_PLAN_DATUM), 0)), false)), 0, true);
    protected final List<PhoenixPreparedStatement> batch = Lists.newArrayList();

    public PhoenixStatement(PhoenixConnection connection) {
        this.connection = connection;
    }

    protected List<PhoenixResultSet> getResultSets() {
        return this.resultSets;
    }

    protected PhoenixResultSet newResultSet(ResultIterator iterator, RowProjector projector) throws SQLException {
        return new PhoenixResultSet(iterator, projector, this);
    }

    protected boolean execute(CompilableStatement stmt) throws SQLException {
        if (stmt.getOperation().isMutation()) {
            this.executeMutation(stmt);
            return false;
        }
        this.executeQuery(stmt);
        return true;
    }

    protected QueryPlan optimizeQuery(CompilableStatement stmt) throws SQLException {
        QueryPlan plan = (QueryPlan)stmt.compilePlan(this);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    protected PhoenixResultSet executeQuery(CompilableStatement stmt) throws SQLException {
        try {
            QueryPlan plan = (QueryPlan)stmt.compilePlan(this);
            plan = this.connection.getQueryServices().getOptimizer().optimize(this, plan);
            plan.getContext().getSequenceManager().validateSequences(stmt.getSequenceAction());
            PhoenixResultSet rs = this.newResultSet(plan.iterator(), plan.getProjector());
            this.resultSets.add(rs);
            this.setLastQueryPlan(plan);
            this.setLastResultSet(rs);
            this.setLastUpdateCount(-1);
            this.setLastUpdateOperation(stmt.getOperation());
            return rs;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    protected int executeMutation(CompilableStatement stmt) throws SQLException {
        try {
            MutationPlan plan = (MutationPlan)stmt.compilePlan(this);
            plan.getContext().getSequenceManager().validateSequences(stmt.getSequenceAction());
            MutationState state = plan.execute();
            this.connection.getMutationState().join(state);
            if (this.connection.getAutoCommit()) {
                this.connection.commit();
            }
            this.setLastResultSet(null);
            this.setLastQueryPlan(null);
            int lastUpdateCount = (int)Math.min(Integer.MAX_VALUE, state.getUpdateCount());
            this.setLastUpdateCount(lastUpdateCount);
            this.setLastUpdateOperation(stmt.getOperation());
            return lastUpdateCount;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    public Format getFormatter(PDataType type) {
        return this.connection.getFormatter(type);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch.add(new PhoenixPreparedStatement(this.connection, sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = 0;
        try {
            int[] returnCodes = new int[this.batch.size()];
            for (i = 0; i < returnCodes.length; ++i) {
                PhoenixPreparedStatement statement = this.batch.get(i);
                returnCodes[i] = statement.execute(true) ? -2 : statement.getUpdateCount();
            }
            this.clearBatch();
            return returnCodes;
        }
        catch (Throwable t) {
            throw new BatchUpdateExecution(t, i);
        }
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            List<PhoenixResultSet> resultSets = this.resultSets;
            this.resultSets = Lists.newArrayList();
            SQLCloseables.closeAll(resultSets);
        }
        finally {
            try {
                this.connection.removeStatement(this);
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public List<Object> getParameters() {
        return Collections.emptyList();
    }

    protected CompilableStatement parseStatement(String sql) throws SQLException {
        PhoenixStatementParser parser = null;
        try {
            parser = new PhoenixStatementParser(sql, (ParseNodeFactory)new ExecutableNodeFactory());
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        CompilableStatement statement = parser.parseStatement();
        return statement;
    }

    public QueryPlan optimizeQuery(String sql) throws SQLException {
        QueryPlan plan = this.compileQuery(sql);
        return this.connection.getQueryServices().getOptimizer().optimize(this, plan);
    }

    public QueryPlan compileQuery(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileQuery(stmt, sql);
    }

    public QueryPlan compileQuery(CompilableStatement stmt, String query) throws SQLException {
        if (stmt.getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(query);
        }
        return (QueryPlan)stmt.compilePlan(this);
    }

    public MutationPlan compileMutation(CompilableStatement stmt, String query) throws SQLException {
        if (!stmt.getOperation().isMutation()) {
            throw new ExecuteUpdateNotApplicableException(query);
        }
        return (MutationPlan)stmt.compilePlan(this);
    }

    public MutationPlan compileMutation(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        return this.compileMutation(stmt, sql);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (stmt.getOperation().isMutation()) {
            throw new ExecuteQueryNotApplicableException(sql);
        }
        return this.executeQuery(stmt);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (!stmt.getOperation().isMutation) {
            throw new ExecuteUpdateNotApplicableException(sql);
        }
        if (!this.batch.isEmpty()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
        }
        return this.executeMutation(stmt);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        CompilableStatement stmt = this.parseStatement(sql);
        if (stmt.getOperation().isMutation()) {
            if (!this.batch.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.EXECUTE_UPDATE_WITH_NON_EMPTY_BATCH).build().buildException();
            }
            this.executeMutation(stmt);
            return false;
        }
        this.executeQuery(stmt);
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PhoenixConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.connection.getQueryServices().getProps().getInt("hbase.client.scanner.caching", 1000);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.connection.getQueryServices().getProps().getInt("phoenix.query.keepAliveMs", 0) / 1000;
    }

    public QueryPlan getQueryPlan() {
        return this.getLastQueryPlan();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        PhoenixResultSet rs = this.getLastResultSet();
        this.setLastResultSet(null);
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    public Operation getUpdateOperation() {
        return this.getLastUpdateOperation();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int updateCount = this.getLastUpdateCount();
        this.setLastUpdateCount(-1);
        return updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private PhoenixResultSet getLastResultSet() {
        return this.lastResultSet;
    }

    private void setLastResultSet(PhoenixResultSet lastResultSet) {
        this.lastResultSet = lastResultSet;
    }

    private int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    private void setLastUpdateCount(int lastUpdateCount) {
        this.lastUpdateCount = lastUpdateCount;
    }

    private Operation getLastUpdateOperation() {
        return this.lastUpdateOperation;
    }

    private void setLastUpdateOperation(Operation lastUpdateOperation) {
        this.lastUpdateOperation = lastUpdateOperation;
    }

    private QueryPlan getLastQueryPlan() {
        return this.lastQueryPlan;
    }

    private void setLastQueryPlan(QueryPlan lastQueryPlan) {
        this.lastQueryPlan = lastQueryPlan;
    }

    static class PhoenixStatementParser
    extends SQLParser {
        PhoenixStatementParser(String query, ParseNodeFactory nodeFactory) throws IOException {
            super(query, nodeFactory);
        }

        PhoenixStatementParser(Reader reader) throws IOException {
            super(reader);
        }

        @Override
        public CompilableStatement nextStatement(ParseNodeFactory nodeFactory) throws SQLException {
            return (CompilableStatement)super.nextStatement(nodeFactory);
        }

        @Override
        public CompilableStatement parseStatement() throws SQLException {
            return (CompilableStatement)super.parseStatement();
        }
    }

    protected static class ExecutableNodeFactory
    extends ParseNodeFactory {
        protected ExecutableNodeFactory() {
        }

        @Override
        public ExecutableSelectStatement select(List<? extends TableNode> from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, int bindCount, boolean isAggregate) {
            return new ExecutableSelectStatement(from, hint, isDistinct, select, where, groupBy == null ? Collections.emptyList() : groupBy, having, orderBy == null ? Collections.emptyList() : orderBy, limit, bindCount, isAggregate);
        }

        @Override
        public ExecutableUpsertStatement upsert(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount) {
            return new ExecutableUpsertStatement(table, hintNode, columns, values, select, bindCount);
        }

        @Override
        public ExecutableDeleteStatement delete(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount) {
            return new ExecutableDeleteStatement(table, hint, whereNode, orderBy, limit, bindCount);
        }

        @Override
        public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount) {
            return new ExecutableCreateTableStatement(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount);
        }

        @Override
        public CreateSequenceStatement createSequence(TableName tableName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, boolean ifNotExists, int bindCount) {
            return new ExecutableCreateSequenceStatement(tableName, startsWith, incrementBy, cacheSize, ifNotExists, bindCount);
        }

        @Override
        public DropSequenceStatement dropSequence(TableName tableName, boolean ifExists, int bindCount) {
            return new ExecutableDropSequenceStatement(tableName, ifExists, bindCount);
        }

        @Override
        public CreateIndexStatement createIndex(NamedNode indexName, NamedTableNode dataTable, PrimaryKeyConstraint pkConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
            return new ExecutableCreateIndexStatement(indexName, dataTable, pkConstraint, includeColumns, splits, props, ifNotExists, bindCount);
        }

        @Override
        public AddColumnStatement addColumn(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, Map<String, Object> props) {
            return new ExecutableAddColumnStatement(table, tableType, columnDefs, ifNotExists, props);
        }

        @Override
        public DropColumnStatement dropColumn(NamedTableNode table, PTableType tableType, List<ColumnName> columnNodes, boolean ifExists) {
            return new ExecutableDropColumnStatement(table, tableType, columnNodes, ifExists);
        }

        @Override
        public DropTableStatement dropTable(TableName tableName, PTableType tableType, boolean ifExists) {
            return new ExecutableDropTableStatement(tableName, tableType, ifExists);
        }

        @Override
        public DropIndexStatement dropIndex(NamedNode indexName, TableName tableName, boolean ifExists) {
            return new ExecutableDropIndexStatement(indexName, tableName, ifExists);
        }

        @Override
        public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state) {
            return new ExecutableAlterIndexStatement(indexTableNode, dataTableName, ifExists, state);
        }

        @Override
        public ExplainStatement explain(BindableStatement statement) {
            return new ExecutableExplainStatement(statement);
        }
    }

    private static class ExecutableDropColumnStatement
    extends DropColumnStatement
    implements CompilableStatement {
        ExecutableDropColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnName> columnRefs, boolean ifExists) {
            super(table, tableType, columnRefs, ifExists);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new MutationPlan(){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return new PhoenixParameterMetaData(0);
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)ExecutableDropColumnStatement.this.getTableType()) + " DROP COLUMN"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return stmt.getConnection();
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getConnection());
                    return client.dropColumn(ExecutableDropColumnStatement.this);
                }
            };
        }
    }

    private static class ExecutableAddColumnStatement
    extends AddColumnStatement
    implements CompilableStatement {
        ExecutableAddColumnStatement(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, Map<String, Object> props) {
            super(table, tableType, columnDefs, ifNotExists, props);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new MutationPlan(){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER " + (Object)((Object)ExecutableAddColumnStatement.this.getTableType()) + " ADD COLUMN"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return stmt.getConnection();
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getConnection());
                    return client.addColumn(ExecutableAddColumnStatement.this);
                }
            };
        }
    }

    private static class ExecutableAlterIndexStatement
    extends AlterIndexStatement
    implements CompilableStatement {
        public ExecutableAlterIndexStatement(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state) {
            super(indexTableNode, dataTableName, ifExists, state);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new MutationPlan(){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("ALTER INDEX"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return stmt.getConnection();
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getConnection());
                    return client.alterIndex(ExecutableAlterIndexStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropIndexStatement
    extends DropIndexStatement
    implements CompilableStatement {
        public ExecutableDropIndexStatement(NamedNode indexName, TableName tableName, boolean ifExists) {
            super(indexName, tableName, ifExists);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new MutationPlan(){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP INDEX"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return stmt.getConnection();
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getConnection());
                    return client.dropIndex(ExecutableDropIndexStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropTableStatement
    extends DropTableStatement
    implements CompilableStatement {
        ExecutableDropTableStatement(TableName tableName, PTableType tableType, boolean ifExists) {
            super(tableName, tableType, ifExists);
        }

        public MutationPlan compilePlan(final PhoenixStatement stmt) throws SQLException {
            final StatementContext context = new StatementContext(stmt);
            return new MutationPlan(){

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DROP TABLE"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return stmt.getConnection();
                }

                @Override
                public MutationState execute() throws SQLException {
                    MetaDataClient client = new MetaDataClient(this.getConnection());
                    return client.dropTable(ExecutableDropTableStatement.this);
                }
            };
        }
    }

    private static class ExecutableDropSequenceStatement
    extends DropSequenceStatement
    implements CompilableStatement {
        public ExecutableDropSequenceStatement(TableName sequenceName, boolean ifExists, int bindCount) {
            super(sequenceName, ifExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            DropSequenceCompiler compiler = new DropSequenceCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateSequenceStatement
    extends CreateSequenceStatement
    implements CompilableStatement {
        public ExecutableCreateSequenceStatement(TableName sequenceName, ParseNode startWith, ParseNode incrementBy, ParseNode cacheSize, boolean ifNotExists, int bindCount) {
            super(sequenceName, startWith, incrementBy, cacheSize, ifNotExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            CreateSequenceCompiler compiler = new CreateSequenceCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateIndexStatement
    extends CreateIndexStatement
    implements CompilableStatement {
        public ExecutableCreateIndexStatement(NamedNode indexName, NamedTableNode dataTable, PrimaryKeyConstraint pkConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
            super(indexName, dataTable, pkConstraint, includeColumns, splits, props, ifNotExists, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            CreateIndexCompiler compiler = new CreateIndexCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableCreateTableStatement
    extends CreateTableStatement
    implements CompilableStatement {
        ExecutableCreateTableStatement(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columnDefs, PrimaryKeyConstraint pkConstraint, List<ParseNode> splitNodes, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount) {
            super(tableName, props, columnDefs, pkConstraint, splitNodes, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            CreateTableCompiler compiler = new CreateTableCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableDeleteStatement
    extends DeleteStatement
    implements CompilableStatement {
        private ExecutableDeleteStatement(NamedTableNode table, HintNode hint, ParseNode whereNode, List<OrderByNode> orderBy, LimitNode limit, int bindCount) {
            super(table, hint, whereNode, orderBy, limit, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            DeleteCompiler compiler = new DeleteCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableUpsertStatement
    extends UpsertStatement
    implements CompilableStatement {
        private ExecutableUpsertStatement(NamedTableNode table, HintNode hintNode, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount) {
            super(table, hintNode, columns, values, select, bindCount);
        }

        public MutationPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            UpsertCompiler compiler = new UpsertCompiler(stmt);
            return compiler.compile(this);
        }
    }

    private static class ExecutableExplainStatement
    extends ExplainStatement
    implements CompilableStatement {
        public ExecutableExplainStatement(BindableStatement statement) {
            super(statement);
        }

        @Override
        public CompilableStatement getStatement() {
            return (CompilableStatement)super.getStatement();
        }

        @Override
        public int getBindCount() {
            return this.getStatement().getBindCount();
        }

        public QueryPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            CompilableStatement compilableStmt = this.getStatement();
            Object plan = compilableStmt.compilePlan(stmt);
            List<String> planSteps = plan.getExplainPlan().getPlanSteps();
            ArrayList<Tuple> tuples = Lists.newArrayListWithExpectedSize(planSteps.size());
            for (String planStep : planSteps) {
                SingleKeyValueTuple tuple = new SingleKeyValueTuple(KeyValueUtil.newKeyValue(PDataType.VARCHAR.toBytes(planStep), EXPLAIN_PLAN_FAMILY, EXPLAIN_PLAN_COLUMN, 0L, ByteUtil.EMPTY_BYTE_ARRAY));
                tuples.add(tuple);
            }
            final MaterializedResultIterator iterator = new MaterializedResultIterator(tuples);
            return new QueryPlan((StatementPlan)plan){
                final /* synthetic */ StatementPlan val$plan;
                {
                    this.val$plan = statementPlan;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("EXPLAIN PLAN"));
                }

                @Override
                public ResultIterator iterator() throws SQLException {
                    return iterator;
                }

                @Override
                public long getEstimatedSize() {
                    return 0L;
                }

                @Override
                public TableRef getTableRef() {
                    return null;
                }

                @Override
                public RowProjector getProjector() {
                    return EXPLAIN_PLAN_ROW_PROJECTOR;
                }

                @Override
                public Integer getLimit() {
                    return null;
                }

                @Override
                public OrderByCompiler.OrderBy getOrderBy() {
                    return OrderByCompiler.OrderBy.EMPTY_ORDER_BY;
                }

                @Override
                public GroupByCompiler.GroupBy getGroupBy() {
                    return GroupByCompiler.GroupBy.EMPTY_GROUP_BY;
                }

                @Override
                public List<KeyRange> getSplits() {
                    return Collections.emptyList();
                }

                @Override
                public StatementContext getContext() {
                    return this.val$plan.getContext();
                }

                @Override
                public FilterableStatement getStatement() {
                    return null;
                }

                @Override
                public boolean isDegenerate() {
                    return false;
                }
            };
        }
    }

    private static class ExecutableSelectStatement
    extends SelectStatement
    implements CompilableStatement {
        private ExecutableSelectStatement(List<? extends TableNode> from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, int bindCount, boolean isAggregate) {
            super(from, hint, isDistinct, select, where, groupBy, having, orderBy, limit, bindCount, isAggregate);
        }

        public QueryPlan compilePlan(PhoenixStatement stmt) throws SQLException {
            ColumnResolver resolver = FromCompiler.getResolverForQuery(this, stmt.getConnection());
            SelectStatement select = StatementNormalizer.normalize(this, resolver);
            return new QueryCompiler(stmt, select, resolver).compile();
        }
    }

    protected static interface CompilableStatement
    extends BindableStatement {
        public <T extends StatementPlan> T compilePlan(PhoenixStatement var1) throws SQLException;
    }

    public static enum Operation {
        QUERY("queried", false),
        DELETE("deleted", true),
        UPSERT("upserted", true);

        private final String toString;
        private final boolean isMutation;

        private Operation(String toString, boolean isMutation) {
            this.toString = toString;
            this.isMutation = isMutation;
        }

        public boolean isMutation() {
            return this.isMutation;
        }

        public String toString() {
            return this.toString;
        }
    }
}

