/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.job;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.job.AbstractRoundRobinQueue;

public class JobManager<T>
extends AbstractRoundRobinQueue<T> {
    private static final AtomicLong PHOENIX_POOL_INDEX = new AtomicLong(1L);

    public JobManager(int maxSize) {
        super(maxSize, true);
    }

    @Override
    protected Object extractProducer(T o) {
        return ((JobFutureTask)o).getJobId();
    }

    public static ThreadPoolExecutor createThreadPoolExec(int keepAliveMs, int size, int queueSize) {
        AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : new JobManager(queueSize);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("phoenix-" + PHOENIX_POOL_INDEX.getAndIncrement() + "-thread-%s").setDaemon(true).build();
        ThreadPoolExecutor exec = new ThreadPoolExecutor(size, size, (long)keepAliveMs, TimeUnit.MILLISECONDS, (BlockingQueue)((Object)queue), threadFactory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> call) {
                return new JobFutureTask<T>(call);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new JobFutureTask<T>(runnable, value);
            }
        };
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }

    public static interface JobCallable<T>
    extends Callable<T> {
        public Object getJobId();
    }

    static class JobFutureTask<T>
    extends FutureTask<T> {
        private final Object jobId;

        public JobFutureTask(Runnable r, T t) {
            super(r, t);
            this.jobId = r instanceof JobRunnable ? ((JobRunnable)r).getJobId() : this;
        }

        public JobFutureTask(Callable<T> c) {
            super(c);
            this.jobId = c instanceof JobCallable ? ((JobCallable)c).getJobId() : this;
        }

        public Object getJobId() {
            return this.jobId;
        }
    }

    public static interface JobRunnable<T>
    extends Runnable {
        public Object getJobId();
    }
}

