/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.join;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.SchemaUtil;

public class HashJoinInfo {
    private static final String HASH_JOIN = "HashJoin";
    private KeyValueSchema joinedSchema;
    private ImmutableBytesPtr[] joinIds;
    private List<Expression>[] joinExpressions;
    private JoinTableNode.JoinType[] joinTypes;
    private boolean[] earlyEvaluation;
    private KeyValueSchema[] schemas;
    private int[] fieldPositions;
    private Expression postJoinFilterExpression;

    public HashJoinInfo(PTable joinedTable, ImmutableBytesPtr[] joinIds, List<Expression>[] joinExpressions, JoinTableNode.JoinType[] joinTypes, boolean[] earlyEvaluation, PTable[] tables, int[] fieldPositions, Expression postJoinFilterExpression) {
        this(HashJoinInfo.buildSchema(joinedTable), joinIds, joinExpressions, joinTypes, earlyEvaluation, HashJoinInfo.buildSchemas(tables), fieldPositions, postJoinFilterExpression);
    }

    private static KeyValueSchema[] buildSchemas(PTable[] tables) {
        KeyValueSchema[] schemas = new KeyValueSchema[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            schemas[i] = HashJoinInfo.buildSchema(tables[i]);
        }
        return schemas;
    }

    private static KeyValueSchema buildSchema(PTable table) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        if (table != null) {
            for (PColumn column : table.getColumns()) {
                if (SchemaUtil.isPKColumn(column)) continue;
                builder.addField(column);
            }
        }
        return builder.build();
    }

    private HashJoinInfo(KeyValueSchema joinedSchema, ImmutableBytesPtr[] joinIds, List<Expression>[] joinExpressions, JoinTableNode.JoinType[] joinTypes, boolean[] earlyEvaluation, KeyValueSchema[] schemas, int[] fieldPositions, Expression postJoinFilterExpression) {
        this.joinedSchema = joinedSchema;
        this.joinIds = joinIds;
        this.joinExpressions = joinExpressions;
        this.joinTypes = joinTypes;
        this.earlyEvaluation = earlyEvaluation;
        this.schemas = schemas;
        this.fieldPositions = fieldPositions;
        this.postJoinFilterExpression = postJoinFilterExpression;
    }

    public KeyValueSchema getJoinedSchema() {
        return this.joinedSchema;
    }

    public ImmutableBytesPtr[] getJoinIds() {
        return this.joinIds;
    }

    public List<Expression>[] getJoinExpressions() {
        return this.joinExpressions;
    }

    public JoinTableNode.JoinType[] getJoinTypes() {
        return this.joinTypes;
    }

    public boolean[] earlyEvaluation() {
        return this.earlyEvaluation;
    }

    public KeyValueSchema[] getSchemas() {
        return this.schemas;
    }

    public int[] getFieldPositions() {
        return this.fieldPositions;
    }

    public Expression getPostJoinFilterExpression() {
        return this.postJoinFilterExpression;
    }

    public static void serializeHashJoinIntoScan(Scan scan, HashJoinInfo joinInfo) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            joinInfo.joinedSchema.write(output);
            int count = joinInfo.joinIds.length;
            WritableUtils.writeVInt(output, count);
            for (int i = 0; i < count; ++i) {
                joinInfo.joinIds[i].write(output);
                WritableUtils.writeVInt(output, joinInfo.joinExpressions[i].size());
                for (Expression expr : joinInfo.joinExpressions[i]) {
                    WritableUtils.writeVInt(output, ExpressionType.valueOf(expr).ordinal());
                    expr.write(output);
                }
                WritableUtils.writeVInt(output, joinInfo.joinTypes[i].ordinal());
                output.writeBoolean(joinInfo.earlyEvaluation[i]);
                joinInfo.schemas[i].write(output);
                WritableUtils.writeVInt(output, joinInfo.fieldPositions[i]);
            }
            if (joinInfo.postJoinFilterExpression != null) {
                WritableUtils.writeVInt(output, ExpressionType.valueOf(joinInfo.postJoinFilterExpression).ordinal());
                joinInfo.postJoinFilterExpression.write(output);
            } else {
                WritableUtils.writeVInt(output, -1);
            }
            scan.setAttribute(HASH_JOIN, stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static HashJoinInfo deserializeHashJoinFromScan(Scan scan) {
        byte[] join = scan.getAttribute(HASH_JOIN);
        if (join == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(join);
        try {
            DataInputStream input = new DataInputStream(stream);
            KeyValueSchema joinedSchema = new KeyValueSchema();
            joinedSchema.readFields(input);
            int count = WritableUtils.readVInt(input);
            ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[count];
            List[] joinExpressions = new List[count];
            JoinTableNode.JoinType[] joinTypes = new JoinTableNode.JoinType[count];
            boolean[] earlyEvaluation = new boolean[count];
            KeyValueSchema[] schemas = new KeyValueSchema[count];
            int[] fieldPositions = new int[count];
            for (int i = 0; i < count; ++i) {
                joinIds[i] = new ImmutableBytesPtr();
                joinIds[i].readFields(input);
                int nExprs = WritableUtils.readVInt(input);
                joinExpressions[i] = new ArrayList(nExprs);
                for (int j = 0; j < nExprs; ++j) {
                    int expressionOrdinal = WritableUtils.readVInt(input);
                    Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                    expression.readFields(input);
                    joinExpressions[i].add(expression);
                }
                int type = WritableUtils.readVInt(input);
                joinTypes[i] = JoinTableNode.JoinType.values()[type];
                earlyEvaluation[i] = input.readBoolean();
                schemas[i] = new KeyValueSchema();
                schemas[i].readFields(input);
                fieldPositions[i] = WritableUtils.readVInt(input);
            }
            Expression postJoinFilterExpression = null;
            int expressionOrdinal = WritableUtils.readVInt(input);
            if (expressionOrdinal != -1) {
                postJoinFilterExpression = ExpressionType.values()[expressionOrdinal].newInstance();
                postJoinFilterExpression.readFields(input);
            }
            HashJoinInfo hashJoinInfo = new HashJoinInfo(joinedSchema, joinIds, joinExpressions, joinTypes, earlyEvaluation, schemas, fieldPositions, postJoinFilterExpression);
            return hashJoinInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

