/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.CsvToKeyValueMapper;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.util.ColumnInfo;

public class CsvBulkImportUtil {
    public static void initCsvImportJob(Configuration conf, String tableName, char fieldDelimiter, String arrayDelimiter, List<ColumnInfo> columnInfoList, boolean ignoreInvalidRows) {
        Preconditions.checkNotNull(tableName);
        Preconditions.checkNotNull(columnInfoList);
        Preconditions.checkArgument(!columnInfoList.isEmpty(), "Column info list is empty");
        conf.set("phoenix.mapreduce.import.tablename", tableName);
        conf.set("phoenix.mapreduce.import.fielddelimiter", String.valueOf(fieldDelimiter));
        if (arrayDelimiter != null) {
            conf.set("phoenix.mapreduce.import.arraydelimiter", arrayDelimiter);
        }
        CsvToKeyValueMapper.configureColumnInfoList(conf, columnInfoList);
        conf.setBoolean("phoenix.mapreduce.import.ignoreinvalidrow", ignoreInvalidRows);
    }

    public static void configurePreUpsertProcessor(Configuration conf, Class<? extends ImportPreUpsertKeyValueProcessor> processorClass) {
        conf.setClass("phoenix.mapreduce.import.kvprocessor", processorClass, ImportPreUpsertKeyValueProcessor.class);
    }
}

