/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.CsvToKeyValueMapper;
import org.apache.phoenix.util.CSVCommonsLoader;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvBulkLoadTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CsvBulkLoadTool.class);
    static final Option ZK_QUORUM_OPT = new Option("z", "zookeeper", true, "Zookeeper quorum to connect to (optional)");
    static final Option INPUT_PATH_OPT = new Option("i", "input", true, "Input CSV path (mandatory)");
    static final Option OUTPUT_PATH_OPT = new Option("o", "output", true, "Output path for temporary HFiles (optional)");
    static final Option SCHEMA_NAME_OPT = new Option("s", "schema", true, "Phoenix schema name (optional)");
    static final Option TABLE_NAME_OPT = new Option("t", "table", true, "Phoenix table name (mandatory)");
    static final Option DELIMITER_OPT = new Option("d", "delimiter", true, "Input delimiter, defaults to comma");
    static final Option ARRAY_DELIMITER_OPT = new Option("a", "array-delimiter", true, "Array element delimiter (optional)");
    static final Option IMPORT_COLUMNS_OPT = new Option("c", "import-columns", true, "Comma-separated list of columns to be imported");
    static final Option IGNORE_ERRORS_OPT = new Option("g", "ignore-errors", false, "Ignore input errors");
    static final Option HELP_OPT = new Option("h", "help", false, "Show this help and quit");

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new CsvBulkLoadTool(), args);
    }

    CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPT.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(TABLE_NAME_OPT.getOpt())) {
            throw new IllegalStateException(TABLE_NAME_OPT.getLongOpt() + " is a mandatory " + "parameter");
        }
        if (!cmdLine.getArgList().isEmpty()) {
            throw new IllegalStateException("Got unexpected extra parameters: " + cmdLine.getArgList());
        }
        if (!cmdLine.hasOption(INPUT_PATH_OPT.getOpt())) {
            throw new IllegalStateException(INPUT_PATH_OPT.getLongOpt() + " is a mandatory " + "parameter");
        }
        return cmdLine;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(INPUT_PATH_OPT);
        options.addOption(TABLE_NAME_OPT);
        options.addOption(ZK_QUORUM_OPT);
        options.addOption(OUTPUT_PATH_OPT);
        options.addOption(SCHEMA_NAME_OPT);
        options.addOption(DELIMITER_OPT);
        options.addOption(ARRAY_DELIMITER_OPT);
        options.addOption(IMPORT_COLUMNS_OPT);
        options.addOption(IGNORE_ERRORS_OPT);
        options.addOption(HELP_OPT);
        return options;
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        HBaseConfiguration.addHbaseResources(this.getConf());
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
        }
        Class.forName(DriverManager.class.getName());
        Connection conn = DriverManager.getConnection(this.getJdbcUrl(cmdLine.getOptionValue(ZK_QUORUM_OPT.getOpt())));
        String tableName = cmdLine.getOptionValue(TABLE_NAME_OPT.getOpt());
        String schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPT.getOpt());
        String qualifiedTableName = CsvBulkLoadTool.getQualifiedTableName(schemaName, tableName);
        List<ColumnInfo> importColumns = this.buildImportColumns(conn, cmdLine, qualifiedTableName);
        CsvBulkLoadTool.configureOptions(cmdLine, importColumns, this.getConf());
        try {
            this.validateTable(conn, schemaName, tableName);
        }
        finally {
            conn.close();
        }
        Path inputPath = new Path(cmdLine.getOptionValue(INPUT_PATH_OPT.getOpt()));
        Path outputPath = null;
        outputPath = cmdLine.hasOption(OUTPUT_PATH_OPT.getOpt()) ? new Path(cmdLine.getOptionValue(OUTPUT_PATH_OPT.getOpt())) : new Path("/tmp/" + UUID.randomUUID());
        LOG.info("Configuring HFile output path to {}", outputPath);
        Job job = new Job(this.getConf(), "Phoenix MapReduce import for " + this.getConf().get("phoenix.mapreduce.import.tablename"));
        if (job.getJar() == null) {
            job.setJarByClass(CsvToKeyValueMapper.class);
        }
        job.setInputFormatClass(TextInputFormat.class);
        FileInputFormat.addInputPath(job, inputPath);
        FileSystem.get(this.getConf());
        FileOutputFormat.setOutputPath(job, outputPath);
        job.setMapperClass(CsvToKeyValueMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
        HTable htable = new HTable(this.getConf(), qualifiedTableName);
        HFileOutputFormat.configureIncrementalLoad(job, htable);
        LOG.info("Running MapReduce import job from {} to {}", inputPath, (Object)outputPath);
        boolean success = job.waitForCompletion(true);
        if (!success) {
            LOG.error("Import job failed, check JobTracker for details");
            return 1;
        }
        LOG.info("Loading HFiles from {}", outputPath);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.getConf());
        loader.doBulkLoad(outputPath, htable);
        htable.close();
        LOG.info("Incremental load complete");
        LOG.info("Removing output directory {}", outputPath);
        if (!FileSystem.get(this.getConf()).delete(outputPath, true)) {
            LOG.error("Removing output directory {} failed", outputPath);
        }
        return 0;
    }

    String getJdbcUrl(String zkQuorum) {
        if (zkQuorum == null) {
            LOG.warn("Defaulting to localhost for ZooKeeper quorum");
            zkQuorum = "localhost:2181";
        }
        return "jdbc:phoenix:" + zkQuorum;
    }

    List<ColumnInfo> buildImportColumns(Connection conn, CommandLine cmdLine, String qualifiedTableName) throws SQLException {
        ArrayList<String> userSuppliedColumnNames = null;
        if (cmdLine.hasOption(IMPORT_COLUMNS_OPT.getOpt())) {
            userSuppliedColumnNames = Lists.newArrayList(Splitter.on(",").trimResults().split(cmdLine.getOptionValue(IMPORT_COLUMNS_OPT.getOpt())));
        }
        return CSVCommonsLoader.generateColumnInfo(conn, qualifiedTableName, userSuppliedColumnNames, true);
    }

    @VisibleForTesting
    static String getQualifiedTableName(String schemaName, String tableName) {
        if (schemaName != null) {
            return String.format("%s.%s", SchemaUtil.normalizeIdentifier(schemaName), SchemaUtil.normalizeIdentifier(tableName));
        }
        return SchemaUtil.normalizeIdentifier(tableName);
    }

    @VisibleForTesting
    static void configureOptions(CommandLine cmdLine, List<ColumnInfo> importColumns, Configuration conf) {
        char delimiterChar = ',';
        if (cmdLine.hasOption(DELIMITER_OPT.getOpt())) {
            String delimString = cmdLine.getOptionValue(DELIMITER_OPT.getOpt());
            if (delimString.length() != 1) {
                throw new IllegalArgumentException("Illegal delimiter character: " + delimString);
            }
            delimiterChar = delimString.charAt(0);
        }
        if (cmdLine.hasOption(ZK_QUORUM_OPT.getOpt())) {
            String zkQuorum = cmdLine.getOptionValue(ZK_QUORUM_OPT.getOpt());
            LOG.info("Configuring ZK quorum to {}", (Object)zkQuorum);
            conf.set("hbase.zookeeper.quorum", zkQuorum);
        }
        CsvBulkImportUtil.initCsvImportJob(conf, CsvBulkLoadTool.getQualifiedTableName(cmdLine.getOptionValue(SCHEMA_NAME_OPT.getOpt()), cmdLine.getOptionValue(TABLE_NAME_OPT.getOpt())), delimiterChar, cmdLine.getOptionValue(ARRAY_DELIMITER_OPT.getOpt()), importColumns, cmdLine.hasOption(IGNORE_ERRORS_OPT.getOpt()));
    }

    private void validateTable(Connection conn, String schemaName, String tableName) throws SQLException {
        ResultSet rs = conn.getMetaData().getColumns(null, StringUtil.escapeLike(schemaName), StringUtil.escapeLike(tableName), null);
        while (rs.next()) {
            String familyName = rs.getString("COLUMN_FAMILY");
            if (familyName == null || !familyName.startsWith("_")) continue;
            if ("0".equals(familyName)) {
                throw new IllegalStateException("CSV Bulk Loader error: All column names that are not part of the primary key constraint must be prefixed with a column family name (i.e. f.my_column VARCHAR)");
            }
            throw new IllegalStateException("CSV Bulk Loader error: Column family name must not start with '_': " + familyName);
        }
        rs.close();
    }
}

