/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.optimize;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;

public class QueryOptimizer {
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final QueryServices services;
    private final boolean useIndexes;

    public QueryOptimizer(QueryServices services) {
        this.services = services;
        this.useIndexes = this.services.getProps().getBoolean("phoenix.query.useIndexes", true);
    }

    public QueryPlan optimize(PhoenixStatement statement, QueryPlan dataPlan) throws SQLException {
        if (dataPlan.getTableRef() == null) {
            return dataPlan;
        }
        return this.optimize(dataPlan, statement, Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select) throws SQLException {
        return this.optimize(statement, select, FromCompiler.getResolverForQuery(select, statement.getConnection()), Collections.emptyList(), null);
    }

    public QueryPlan optimize(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        QueryCompiler compiler = new QueryCompiler(statement, select, resolver, targetColumns, parallelIteratorFactory);
        QueryPlan dataPlan = compiler.compile();
        return this.optimize(dataPlan, statement, targetColumns, parallelIteratorFactory);
    }

    public QueryPlan optimize(QueryPlan dataPlan, PhoenixStatement statement, List<? extends PDatum> targetColumns, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        SelectStatement select = (SelectStatement)dataPlan.getStatement();
        if (!this.useIndexes || select.getFrom().size() > 1) {
            return dataPlan;
        }
        PTable dataTable = dataPlan.getTableRef().getTable();
        ArrayList<PTable> indexes = Lists.newArrayList(dataTable.getIndexes());
        if (indexes.isEmpty() || dataPlan.isDegenerate() || dataPlan.getTableRef().hasDynamicCols() || select.getHint().hasHint(HintNode.Hint.NO_INDEX)) {
            return dataPlan;
        }
        if (targetColumns.isEmpty()) {
            List<? extends ColumnProjector> projectors = dataPlan.getProjector().getColumnProjectors();
            ArrayList<? extends PDatum> targetDatums = Lists.newArrayListWithExpectedSize(projectors.size());
            for (ColumnProjector columnProjector : projectors) {
                targetDatums.add(columnProjector.getExpression());
            }
            targetColumns = targetDatums;
        }
        SelectStatement translatedIndexSelect = IndexStatementRewriter.translate(select, dataPlan.getContext().getResolver());
        ArrayList<QueryPlan> plans = Lists.newArrayListWithExpectedSize(1 + indexes.size());
        plans.add(dataPlan);
        QueryPlan hintedPlan = QueryOptimizer.getHintedQueryPlan(statement, translatedIndexSelect, indexes, targetColumns, parallelIteratorFactory, plans);
        if (hintedPlan != null) {
            return hintedPlan;
        }
        for (PTable index : indexes) {
            QueryPlan plan = QueryOptimizer.addPlan(statement, translatedIndexSelect, index, targetColumns, parallelIteratorFactory, dataPlan);
            if (plan == null) continue;
            if (plan.isDegenerate()) {
                return plan;
            }
            plans.add(plan);
        }
        return this.chooseBestPlan(select, plans);
    }

    private static QueryPlan getHintedQueryPlan(PhoenixStatement statement, SelectStatement select, List<PTable> indexes, List<? extends PDatum> targetColumns, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory, List<QueryPlan> plans) throws SQLException {
        QueryPlan dataPlan = plans.get(0);
        String indexHint = select.getHint().getHint(HintNode.Hint.INDEX);
        if (indexHint == null) {
            return null;
        }
        int startIndex = 0;
        String alias = dataPlan.getTableRef().getTableAlias();
        String prefix = "(" + (alias == null ? dataPlan.getTableRef().getTable().getName().getString() : alias) + ' ';
        while (startIndex < indexHint.length()) {
            if ((startIndex = indexHint.indexOf(prefix, startIndex)) < 0) {
                return null;
            }
            startIndex += prefix.length();
            boolean done = false;
            while (startIndex < indexHint.length() && !done) {
                int endIndex;
                int endIndex1 = indexHint.indexOf(32, startIndex);
                int endIndex2 = indexHint.indexOf(")", startIndex);
                if (endIndex1 < 0 && endIndex2 < 0) {
                    endIndex = indexHint.length();
                } else if (endIndex1 < 0) {
                    done = true;
                    endIndex = endIndex2;
                } else if (endIndex2 < 0) {
                    endIndex = endIndex1;
                } else {
                    endIndex = Math.min(endIndex1, endIndex2);
                    done = endIndex2 == endIndex;
                }
                String indexName = indexHint.substring(startIndex, endIndex);
                int indexPos = QueryOptimizer.getIndexPosition(indexes, indexName);
                if (indexPos >= 0) {
                    QueryPlan plan = QueryOptimizer.addPlan(statement, select, indexes.get(indexPos), targetColumns, parallelIteratorFactory, dataPlan);
                    if (plan != null) {
                        return plan;
                    }
                    indexes.remove(indexPos);
                }
                startIndex = endIndex + 1;
            }
        }
        return null;
    }

    private static int getIndexPosition(List<PTable> indexes, String indexName) {
        for (int i = 0; i < indexes.size(); ++i) {
            if (!indexName.equals(indexes.get(i).getTableName().getString())) continue;
            return i;
        }
        return -1;
    }

    private static QueryPlan addPlan(PhoenixStatement statement, SelectStatement select, PTable index, List<? extends PDatum> targetColumns, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory, QueryPlan dataPlan) throws SQLException {
        int nColumns = dataPlan.getProjector().getColumnCount();
        String alias = '\"' + dataPlan.getTableRef().getTableAlias() + '\"';
        String schemaName = dataPlan.getTableRef().getTable().getSchemaName().getString();
        schemaName = schemaName.length() == 0 ? null : '\"' + schemaName + '\"';
        String tableName = '\"' + index.getTableName().getString() + '\"';
        List<NamedTableNode> tables = Collections.singletonList(FACTORY.namedTable(alias, FACTORY.table(schemaName, tableName)));
        try {
            QueryCompiler compiler;
            QueryPlan plan;
            SelectStatement indexSelect = FACTORY.select(select, tables);
            ColumnResolver resolver = FromCompiler.getResolverForQuery(indexSelect, statement.getConnection());
            if (PIndexState.ACTIVE.equals((Object)resolver.getTables().get(0).getTable().getIndexState()) && (plan = (compiler = new QueryCompiler(statement, indexSelect, resolver, targetColumns, parallelIteratorFactory)).compile()).getTableRef().getTable().getIndexState() == PIndexState.ACTIVE && plan.getProjector().getColumnCount() == nColumns) {
                return plan;
            }
        }
        catch (ColumnNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private QueryPlan chooseBestPlan(SelectStatement select, List<QueryPlan> plans) {
        final QueryPlan dataPlan = plans.get(0);
        if (plans.size() == 1) {
            return dataPlan;
        }
        ArrayList<QueryPlan> candidates = Lists.newArrayListWithExpectedSize(plans.size());
        for (QueryPlan plan : plans) {
            if (!plan.getContext().getScanRanges().isPointLookup()) continue;
            candidates.add(plan);
        }
        List<QueryPlan> stillCandidates = plans;
        ArrayList<QueryPlan> bestCandidates = candidates;
        if (!candidates.isEmpty()) {
            stillCandidates = candidates;
            bestCandidates = Lists.newArrayListWithExpectedSize(candidates.size());
        }
        for (QueryPlan plan : stillCandidates) {
            if (!plan.getOrderBy().getOrderByExpressions().isEmpty()) continue;
            bestCandidates.add(plan);
        }
        if (bestCandidates.isEmpty()) {
            bestCandidates.addAll(stillCandidates);
        }
        int nViewConstants = 0;
        PTable dataTable = dataPlan.getTableRef().getTable();
        if (dataTable.getType() == PTableType.VIEW) {
            for (PColumn column : dataTable.getColumns()) {
                if (column.getViewConstant() == null) continue;
                ++nViewConstants;
            }
        }
        final int boundRanges = nViewConstants;
        final int comparisonOfDataVersusIndexTable = select.getHint().hasHint(HintNode.Hint.USE_DATA_OVER_INDEX_TABLE) ? -1 : 1;
        Collections.sort(bestCandidates, new Comparator<QueryPlan>(){

            @Override
            public int compare(QueryPlan plan1, QueryPlan plan2) {
                PTable table1 = plan1.getTableRef().getTable();
                PTable table2 = plan2.getTableRef().getTable();
                int c = plan2.getContext().getScanRanges().getRanges().size() - plan1.getContext().getScanRanges().getRanges().size();
                c = plan1 == dataPlan ? (c += boundRanges - (table2.getViewIndexId() == null ? 0 : 1)) : (c -= boundRanges - (table1.getViewIndexId() == null ? 0 : 1));
                if (c != 0) {
                    return c;
                }
                if (plan1.getGroupBy() != null && plan2.getGroupBy() != null && plan1.getGroupBy().isOrderPreserving() != plan2.getGroupBy().isOrderPreserving()) {
                    return plan1.getGroupBy().isOrderPreserving() ? -1 : 1;
                }
                c = table1.getColumns().size() - table1.getPKColumns().size() - (table2.getColumns().size() - table2.getPKColumns().size());
                if (c != 0) {
                    return c;
                }
                if (plan1.getTableRef().getTable().getType() == PTableType.INDEX) {
                    return comparisonOfDataVersusIndexTable;
                }
                if (plan2.getTableRef().getTable().getType() == PTableType.INDEX) {
                    return -comparisonOfDataVersusIndexTable;
                }
                return 0;
            }
        });
        return (QueryPlan)candidates.get(0);
    }
}

