/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.expression.function.RoundTimestampExpression;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.UnaryParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.util.SchemaUtil;

public class CastParseNode
extends UnaryParseNode {
    private final PDataType dt;
    private final Integer maxLength;
    private final Integer scale;

    CastParseNode(ParseNode expr, String dataType, Integer maxLength, Integer scale, boolean arr) {
        this(expr, PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(dataType)), maxLength, scale, arr);
    }

    CastParseNode(ParseNode expr, PDataType dataType, Integer maxLength, Integer scale, boolean arr) {
        super(expr);
        this.dt = arr ? PDataType.fromTypeId(dataType.getSqlType() + 3000) : dataType;
        this.maxLength = maxLength;
        this.scale = scale;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    public PDataType getDataType() {
        return this.dt;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public static Expression convertToRoundExpressionIfNeeded(PDataType fromDataType, PDataType targetDataType, List<Expression> expressions) throws SQLException {
        Expression firstChildExpr = expressions.get(0);
        if (fromDataType == targetDataType) {
            return firstChildExpr;
        }
        if (fromDataType == PDataType.DECIMAL && targetDataType.isCoercibleTo(PDataType.LONG)) {
            return new RoundDecimalExpression(expressions);
        }
        if ((fromDataType == PDataType.TIMESTAMP || fromDataType == PDataType.UNSIGNED_TIMESTAMP) && targetDataType.isCoercibleTo(PDataType.DATE)) {
            return RoundTimestampExpression.create(expressions);
        }
        if (!fromDataType.isCoercibleTo(targetDataType)) {
            throw TypeMismatchException.newException(fromDataType, targetDataType, firstChildExpr.toString());
        }
        return firstChildExpr;
    }
}

