/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.ParseException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.SchemaUtil;

public class ColumnDef {
    private final ColumnName columnDefName;
    private PDataType dataType;
    private final Boolean isNull;
    private final Integer maxLength;
    private final Integer scale;
    private final boolean isPK;
    private final SortOrder sortOrder;
    private final boolean isArray;
    private final Integer arrSize;

    ColumnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder) {
        try {
            Preconditions.checkNotNull(sortOrder);
            PDataType localType = null;
            this.columnDefName = columnDefName;
            this.isArray = isArray;
            if (this.isArray) {
                localType = sqlTypeName == null ? null : PDataType.fromTypeId(PDataType.sqlArrayType(SchemaUtil.normalizeIdentifier(sqlTypeName)));
                this.dataType = sqlTypeName == null ? null : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(sqlTypeName));
                this.arrSize = arrSize;
            } else {
                this.dataType = sqlTypeName == null ? null : PDataType.fromSqlTypeName(SchemaUtil.normalizeIdentifier(sqlTypeName));
                this.arrSize = null;
            }
            this.isNull = isNull;
            if (this.dataType == PDataType.CHAR) {
                if (maxLength == null) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.MISSING_CHAR_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                if (maxLength < 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NONPOSITIVE_CHAR_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                scale = null;
            } else if (this.dataType == PDataType.VARCHAR) {
                if (maxLength != null && maxLength < 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NONPOSITIVE_CHAR_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                scale = null;
            } else if (this.dataType == PDataType.DECIMAL) {
                if (maxLength != null) {
                    if (maxLength < 1 || maxLength > 38) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DECIMAL_PRECISION_OUT_OF_RANGE).setColumnName(columnDefName.getColumnName()).build().buildException();
                    }
                    scale = scale == null ? 0 : (scale > maxLength ? maxLength : scale);
                }
            } else if (this.dataType == PDataType.BINARY) {
                if (maxLength == null) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.MISSING_BINARY_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                if (maxLength < 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NONPOSITIVE_BINARY_LENGTH).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                scale = null;
            } else {
                maxLength = null;
                scale = null;
            }
            this.maxLength = maxLength;
            this.scale = scale;
            this.isPK = isPK;
            this.sortOrder = sortOrder;
            if (this.isArray) {
                this.dataType = localType;
            }
        }
        catch (SQLException e) {
            throw new ParseException(e);
        }
    }

    ColumnDef(ColumnName columnDefName, String sqlTypeName, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder) {
        this(columnDefName, sqlTypeName, false, 0, isNull, maxLength, scale, isPK, sortOrder);
    }

    public ColumnName getColumnDefName() {
        return this.columnDefName;
    }

    public PDataType getDataType() {
        return this.dataType;
    }

    public boolean isNull() {
        return !Boolean.FALSE.equals(this.isNull);
    }

    public boolean isNullSet() {
        return this.isNull != null;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Integer getArraySize() {
        return this.arrSize;
    }
}

