/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.parse.NamedParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TableName;

public class ColumnParseNode
extends NamedParseNode {
    private final TableName tableName;
    private final String fullName;
    private final String alias;

    public ColumnParseNode(TableName tableName, String name, String alias) {
        super(name);
        this.alias = alias;
        this.tableName = tableName;
        this.fullName = tableName == null ? this.getName() : tableName.toString() + "." + this.getName();
    }

    public ColumnParseNode(TableName tableName, String name) {
        this(tableName, name, null);
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public String getTableName() {
        return this.tableName == null ? null : this.tableName.getTableName();
    }

    public String getSchemaName() {
        return this.tableName == null ? null : this.tableName.getSchemaName();
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnParseNode other = (ColumnParseNode)obj;
        return this.fullName.equals(other.fullName);
    }
}

