/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public abstract class CompoundParseNode
extends ParseNode {
    private final List<ParseNode> children;
    private final boolean isStateless;

    CompoundParseNode(List<ParseNode> children) {
        this.children = Collections.unmodifiableList(children);
        boolean isStateless = true;
        for (ParseNode child : children) {
            if (!(isStateless &= child.isStateless())) break;
        }
        this.isStateless = isStateless;
    }

    @Override
    public boolean isStateless() {
        return this.isStateless;
    }

    @Override
    public final List<ParseNode> getChildren() {
        return this.children;
    }

    final <T> List<T> acceptChildren(ParseNodeVisitor<T> visitor) throws SQLException {
        List<T> l = visitor.newElementList(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            T e = this.children.get(i).accept(visitor);
            visitor.addElement(l, e);
        }
        return l;
    }

    public String toString() {
        return this.getClass().getName() + this.children.toString();
    }
}

