/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.SingleTableStatement;
import org.apache.phoenix.parse.TableName;

public class CreateIndexStatement
extends SingleTableStatement {
    private final TableName indexTableName;
    private final PrimaryKeyConstraint indexConstraint;
    private final List<ColumnName> includeColumns;
    private final List<ParseNode> splitNodes;
    private final ListMultimap<String, Pair<String, Object>> props;
    private final boolean ifNotExists;

    public CreateIndexStatement(NamedNode indexTableName, NamedTableNode dataTable, PrimaryKeyConstraint indexConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
        super(dataTable, bindCount);
        this.indexTableName = TableName.create(dataTable.getName().getSchemaName(), indexTableName.getName());
        this.indexConstraint = indexConstraint == null ? PrimaryKeyConstraint.EMPTY : indexConstraint;
        this.includeColumns = includeColumns == null ? Collections.emptyList() : includeColumns;
        this.splitNodes = splits == null ? Collections.emptyList() : splits;
        this.props = props;
        this.ifNotExists = ifNotExists;
    }

    public PrimaryKeyConstraint getIndexConstraint() {
        return this.indexConstraint;
    }

    public List<ColumnName> getIncludeColumns() {
        return this.includeColumns;
    }

    public TableName getIndexTableName() {
        return this.indexTableName;
    }

    public List<ParseNode> getSplitNodes() {
        return this.splitNodes;
    }

    public ListMultimap<String, Pair<String, Object>> getProps() {
        return this.props;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

