/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.MutableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableName;

public class CreateSequenceStatement
extends MutableStatement {
    private final TableName sequenceName;
    private final ParseNode startWith;
    private final ParseNode incrementBy;
    private final ParseNode cacheSize;
    private final boolean ifNotExists;
    private final int bindCount;

    public static CreateSequenceStatement create(TableName sequenceName) {
        return new CreateSequenceStatement(sequenceName, null, null, null, true, 0);
    }

    protected CreateSequenceStatement(TableName sequenceName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, boolean ifNotExists, int bindCount) {
        this.sequenceName = sequenceName;
        this.startWith = startsWith == null ? LiteralParseNode.ONE : startsWith;
        this.incrementBy = incrementBy == null ? LiteralParseNode.ONE : incrementBy;
        this.cacheSize = cacheSize == null ? null : cacheSize;
        this.ifNotExists = ifNotExists;
        this.bindCount = bindCount;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    public ParseNode getIncrementBy() {
        return this.incrementBy;
    }

    public TableName getSequenceName() {
        return this.sequenceName;
    }

    public ParseNode getCacheSize() {
        return this.cacheSize;
    }

    public ParseNode getStartWith() {
        return this.startWith;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

