/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.annotation.Immutable;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.AggregateFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.ArgumentTypeMismatchException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.ValueRangeExcpetion;
import org.apache.phoenix.util.SchemaUtil;

public class FunctionParseNode
extends CompoundParseNode {
    private final String name;
    private final BuiltInFunctionInfo info;

    FunctionParseNode(String name, List<ParseNode> children, BuiltInFunctionInfo info) {
        super(children);
        this.name = SchemaUtil.normalizeIdentifier(name);
        this.info = info;
    }

    public BuiltInFunctionInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.name + "(");
        for (ParseNode child : this.getChildren()) {
            buf.append(child.toString());
            buf.append(',');
        }
        buf.setLength(buf.length() - 1);
        buf.append(')');
        return buf.toString();
    }

    public boolean isAggregate() {
        return this.getInfo().isAggregate();
    }

    public boolean evalToNullIfParamIsNull(StatementContext context, int index) throws SQLException {
        return true;
    }

    private static Constructor<? extends FunctionParseNode> getParseNodeCtor(Class<? extends FunctionParseNode> clazz) {
        Constructor<? extends FunctionParseNode> ctor;
        try {
            ctor = clazz.getDeclaredConstructor(String.class, List.class, BuiltInFunctionInfo.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        return ctor;
    }

    private static Constructor<? extends FunctionExpression> getExpressionCtor(Class<? extends FunctionExpression> clazz) {
        Constructor<? extends FunctionExpression> ctor;
        try {
            ctor = clazz.getDeclaredConstructor(List.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        return ctor;
    }

    public List<Expression> validate(List<Expression> children, StatementContext context) throws SQLException {
        int i;
        BuiltInFunctionInfo info = this.getInfo();
        BuiltInFunctionArgInfo[] args = info.getArgs();
        if (args.length > children.size()) {
            ArrayList<Expression> moreChildren = new ArrayList<Expression>(children);
            for (i = children.size(); i < info.getArgs().length; ++i) {
                moreChildren.add(LiteralExpression.newConstant(null, args[i].allowedTypes.length == 0 ? null : args[i].allowedTypes[0], true));
            }
            children = moreChildren;
        }
        List<ParseNode> nodeChildren = this.getChildren();
        for (i = 0; i < children.size(); ++i) {
            Expression child;
            BindParseNode bindNode = null;
            PDataType[] allowedTypes = args[i].getAllowedTypes();
            if (i < nodeChildren.size() && nodeChildren.get(i) instanceof BindParseNode) {
                bindNode = (BindParseNode)nodeChildren.get(i);
            }
            if ((child = children.get(i)).getDataType() == null || i >= nodeChildren.size()) {
                if (args[i].getDefaultValue() != null) {
                    LiteralExpression defaultValue = args[i].getDefaultValue();
                    children.set(i, defaultValue);
                    if (bindNode == null) continue;
                    context.getBindManager().addParamMetaData(bindNode, defaultValue);
                    continue;
                }
                if (bindNode == null) continue;
                if (child.getDataType() == null) {
                    if (allowedTypes.length <= 0) continue;
                    context.getBindManager().addParamMetaData(bindNode, LiteralExpression.newConstant(null, allowedTypes[0], true));
                    continue;
                }
                context.getBindManager().addParamMetaData(bindNode, child);
                continue;
            }
            if (allowedTypes.length > 0) {
                boolean isCoercible = false;
                for (PDataType type : allowedTypes) {
                    if (!child.getDataType().isCoercibleTo(type)) continue;
                    isCoercible = true;
                    break;
                }
                if (!isCoercible) {
                    throw new ArgumentTypeMismatchException(Arrays.toString((Object[])args[i].getAllowedTypes()), child.getDataType().toString(), info.getName() + " argument " + (i + 1));
                }
                if (child instanceof LiteralExpression) {
                    LiteralExpression valueExp = (LiteralExpression)child;
                    LiteralExpression minValue = args[i].getMinValue();
                    LiteralExpression maxValue = args[i].getMaxValue();
                    if (minValue != null && minValue.getDataType().compareTo(minValue.getValue(), valueExp.getValue(), valueExp.getDataType()) > 0) {
                        throw new ValueRangeExcpetion(minValue, maxValue == null ? "" : maxValue, valueExp.getValue(), info.getName() + " argument " + (i + 1));
                    }
                    if (maxValue != null && maxValue.getDataType().compareTo(maxValue.getValue(), valueExp.getValue(), valueExp.getDataType()) < 0) {
                        throw new ValueRangeExcpetion(minValue == null ? "" : minValue, maxValue, valueExp.getValue(), info.getName() + " argument " + (i + 1));
                    }
                }
            }
            if (args[i].isConstant() && !(child instanceof LiteralExpression)) {
                throw new ArgumentTypeMismatchException("constant", child.toString(), info.getName() + " argument " + (i + 1));
            }
            if (args[i].getAllowedValues().isEmpty()) continue;
            Object value = ((LiteralExpression)child).getValue();
            if (args[i].getAllowedValues().contains(value.toString().toUpperCase())) continue;
            throw new ArgumentTypeMismatchException(Arrays.toString(args[i].getAllowedValues().toArray(new String[0])), value.toString(), info.getName() + " argument " + (i + 1));
        }
        return children;
    }

    public Expression create(List<Expression> children, StatementContext context) throws SQLException {
        try {
            return this.info.getFuncCtor().newInstance(children);
        }
        catch (InstantiationException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(e);
        }
    }

    @Immutable
    public static class BuiltInFunctionArgInfo {
        private static final PDataType[] ENUMERATION_TYPES = new PDataType[]{PDataType.VARCHAR};
        private final PDataType[] allowedTypes;
        private final boolean isConstant;
        private final Set<String> allowedValues;
        private final LiteralExpression defaultValue;
        private final LiteralExpression minValue;
        private final LiteralExpression maxValue;

        BuiltInFunctionArgInfo(Argument argument) {
            if (argument.enumeration().length() > 0) {
                this.isConstant = true;
                this.defaultValue = null;
                this.minValue = null;
                this.maxValue = null;
                this.allowedTypes = ENUMERATION_TYPES;
                Class<?> clazz = null;
                String packageName = FunctionExpression.class.getPackage().getName();
                try {
                    clazz = Class.forName(packageName + "." + argument.enumeration());
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = Class.forName(argument.enumeration());
                    }
                    catch (ClassNotFoundException e1) {
                        // empty catch block
                    }
                }
                if (clazz == null || !clazz.isEnum()) {
                    throw new IllegalStateException("The enumeration annotation '" + argument.enumeration() + "' does not resolve to a enumeration class");
                }
                Class<?> enumClass = clazz;
                Enum[] enums = (Enum[])enumClass.getEnumConstants();
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Enum en : enums) {
                    builder.add(en.name());
                }
                this.allowedValues = builder.build();
            } else {
                this.allowedValues = Collections.emptySet();
                this.isConstant = argument.isConstant();
                this.allowedTypes = argument.allowedTypes();
                this.defaultValue = this.getExpFromConstant(argument.defaultValue());
                this.minValue = this.getExpFromConstant(argument.minValue());
                this.maxValue = this.getExpFromConstant(argument.maxValue());
            }
        }

        private LiteralExpression getExpFromConstant(String strValue) {
            LiteralExpression exp = null;
            if (strValue.length() > 0) {
                SQLParser parser = new SQLParser(strValue);
                try {
                    LiteralParseNode node = parser.parseLiteral();
                    LiteralExpression defaultValue = LiteralExpression.newConstant(node.getValue(), this.allowedTypes[0], true);
                    if (this.getAllowedTypes().length > 0) {
                        for (PDataType type : this.getAllowedTypes()) {
                            if (defaultValue.getDataType() != null && !defaultValue.getDataType().isCoercibleTo(type, node.getValue())) continue;
                            return LiteralExpression.newConstant(node.getValue(), type, true);
                        }
                        throw new IllegalStateException("Unable to coerce default value " + strValue + " to any of the allowed types of " + Arrays.toString((Object[])this.getAllowedTypes()));
                    }
                    exp = defaultValue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return exp;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public LiteralExpression getDefaultValue() {
            return this.defaultValue;
        }

        public LiteralExpression getMinValue() {
            return this.minValue;
        }

        public LiteralExpression getMaxValue() {
            return this.maxValue;
        }

        public PDataType[] getAllowedTypes() {
            return this.allowedTypes;
        }

        public Set<String> getAllowedValues() {
            return this.allowedValues;
        }
    }

    @Immutable
    public static final class BuiltInFunctionInfo {
        private final String name;
        private final Constructor<? extends FunctionExpression> funcCtor;
        private final Constructor<? extends FunctionParseNode> nodeCtor;
        private final BuiltInFunctionArgInfo[] args;
        private final boolean isAggregate;
        private final int requiredArgCount;

        BuiltInFunctionInfo(Class<? extends FunctionExpression> f, BuiltInFunction d) {
            this.name = SchemaUtil.normalizeIdentifier(d.name());
            this.funcCtor = d.nodeClass() == FunctionParseNode.class ? FunctionParseNode.getExpressionCtor(f) : null;
            this.nodeCtor = d.nodeClass() == FunctionParseNode.class ? null : FunctionParseNode.getParseNodeCtor(d.nodeClass());
            this.args = new BuiltInFunctionArgInfo[d.args().length];
            int requiredArgCount = 0;
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = new BuiltInFunctionArgInfo(d.args()[i]);
                if (requiredArgCount >= i || this.args[i].getDefaultValue() == null) continue;
                requiredArgCount = i;
            }
            this.requiredArgCount = requiredArgCount;
            this.isAggregate = AggregateFunction.class.isAssignableFrom(f);
        }

        public int getRequiredArgCount() {
            return this.requiredArgCount;
        }

        public String getName() {
            return this.name;
        }

        public Constructor<? extends FunctionExpression> getFuncCtor() {
            return this.funcCtor;
        }

        public Constructor<? extends FunctionParseNode> getNodeCtor() {
            return this.nodeCtor;
        }

        public boolean isAggregate() {
            return this.isAggregate;
        }

        public BuiltInFunctionArgInfo[] getArgs() {
            return this.args;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Argument {
        public PDataType[] allowedTypes() default {};

        public boolean isConstant() default false;

        public String defaultValue() default "";

        public String enumeration() default "";

        public String minValue() default "";

        public String maxValue() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface BuiltInFunction {
        public String name();

        public Argument[] args() default {};

        public Class<? extends FunctionParseNode> nodeClass() default FunctionParseNode.class;
    }
}

