/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.util.SchemaUtil;

public class HintNode {
    public static final HintNode EMPTY_HINT_NODE = new HintNode();
    public static final char SEPARATOR = ' ';
    public static final String PREFIX = "(";
    public static final String SUFFIX = ")";
    private static final String SPLIT_REGEXP = "\\s+|((?<=\\()|(?=\\())|((?<=\\))|(?=\\)))";
    private final Map<Hint, String> hints;

    public static HintNode create(HintNode hintNode, Hint hint) {
        return HintNode.create(hintNode, hint, "");
    }

    public static HintNode create(HintNode hintNode, Hint hint, String value) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>(hintNode.hints);
        hints.put(hint, value);
        return new HintNode(hints);
    }

    private HintNode() {
        this.hints = new HashMap<Hint, String>();
    }

    private HintNode(Map<Hint, String> hints) {
        this.hints = ImmutableMap.copyOf(hints);
    }

    public HintNode(String hint) {
        HashMap<Hint, String> hints = new HashMap<Hint, String>();
        String[] hintWords = hint.split(SPLIT_REGEXP);
        for (int i = 0; i < hintWords.length; ++i) {
            String hintWord = hintWords[i];
            if (hintWord.isEmpty()) continue;
            try {
                String oldValue;
                Hint key = Hint.valueOf(hintWord.toUpperCase());
                String hintValue = "";
                if (i + 1 < hintWords.length && PREFIX.equals(hintWords[i + 1])) {
                    StringBuffer hintValueBuf = new StringBuffer(hint.length());
                    hintValueBuf.append(PREFIX);
                    i += 2;
                    while (i < hintWords.length && !SUFFIX.equals(hintWords[i])) {
                        hintValueBuf.append(SchemaUtil.normalizeIdentifier(hintWords[i++]));
                        hintValueBuf.append(' ');
                    }
                    hintValueBuf.replace(hintValueBuf.length() - 1, hintValueBuf.length(), SUFFIX);
                    hintValue = hintValueBuf.toString();
                }
                if ((oldValue = hints.put(key, hintValue)) == null) continue;
                hints.put(key, oldValue + hintValue);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.hints = ImmutableMap.copyOf(hints);
    }

    public boolean isEmpty() {
        return this.hints.isEmpty();
    }

    public String getHint(Hint hint) {
        return this.hints.get((Object)hint);
    }

    public boolean hasHint(Hint hint) {
        return this.hints.containsKey((Object)hint);
    }

    public static enum Hint {
        RANGE_SCAN,
        SKIP_SCAN,
        NO_INTRA_REGION_PARALLELIZATION,
        NO_INDEX,
        INDEX,
        USE_DATA_OVER_INDEX_TABLE,
        USE_INDEX_OVER_DATA_TABLE,
        NO_CACHE,
        NO_STAR_JOIN,
        SEEK_TO_COLUMN,
        NO_SEEK_TO_COLUMN;

    }
}

