/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TerminalParseNode;
import org.apache.phoenix.schema.PDataType;

public class LiteralParseNode
extends TerminalParseNode {
    public static final List<ParseNode> STAR = Collections.singletonList(new LiteralParseNode(1));
    public static final ParseNode NULL = new LiteralParseNode(null);
    public static final ParseNode ZERO = new LiteralParseNode(0);
    public static final ParseNode ONE = new LiteralParseNode(1);
    private final Object value;
    private final PDataType type;

    public LiteralParseNode(Object value) {
        this.type = PDataType.fromLiteral(value);
        this.value = this.type == null ? null : this.type.toObject(value, this.type);
    }

    public LiteralParseNode(Object value, PDataType type) {
        this.type = type;
        this.value = this.type == null ? null : this.type.toObject(value, this.type);
    }

    public PDataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public byte[] getBytes() {
        return this.type == null ? null : this.type.toBytes(this.value);
    }

    public String toString() {
        return this.type == PDataType.VARCHAR ? "'" + this.value.toString() + "'" : (this.value == null ? "null" : this.value.toString());
    }
}

