/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.util.SchemaUtil;

public class NamedNode {
    private final String name;
    private final boolean isCaseSensitive;

    public static NamedNode caseSensitiveNamedNode(String name) {
        return new NamedNode(name, true);
    }

    private NamedNode(String name, boolean isCaseSensitive) {
        this.name = name;
        this.isCaseSensitive = isCaseSensitive;
    }

    NamedNode(String name) {
        this.name = SchemaUtil.normalizeIdentifier(name);
        this.isCaseSensitive = name == null ? false : SchemaUtil.isCaseSensitive(name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedNode other = (NamedNode)obj;
        return this.name.equals(other.name);
    }
}

