/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNodeVisitor;

public class NamedTableNode
extends ConcreteTableNode {
    private final List<ColumnDef> dynColumns;

    public static NamedTableNode create(String alias, TableName name, List<ColumnDef> dynColumns) {
        return new NamedTableNode(alias, name, dynColumns);
    }

    NamedTableNode(String alias, TableName name) {
        super(alias, name);
        this.dynColumns = Collections.emptyList();
    }

    NamedTableNode(String alias, TableName name, List<ColumnDef> dynColumns) {
        super(alias, name);
        this.dynColumns = dynColumns != null ? ImmutableList.copyOf(dynColumns) : Collections.emptyList();
    }

    @Override
    public void accept(TableNodeVisitor visitor) throws SQLException {
        visitor.visit(this);
    }

    public List<ColumnDef> getDynamicColumns() {
        return this.dynColumns;
    }
}

