/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.UnknownFunctionException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.function.AvgAggregateFunction;
import org.apache.phoenix.expression.function.CurrentDateFunction;
import org.apache.phoenix.expression.function.CurrentTimeFunction;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AggregateFunctionParseNode;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArrayConstructorNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.BindableStatement;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.DistinctCountParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.ExplainStatement;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.GreaterThanOrEqualParseNode;
import org.apache.phoenix.parse.GreaterThanParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.InParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LessThanOrEqualParseNode;
import org.apache.phoenix.parse.LessThanParseNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.NotEqualParseNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.OuterJoinParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.PropertyName;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.StringConcatParseNode;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.util.SchemaUtil;

public class ParseNodeFactory {
    private static final String ARRAY_ELEM = "ARRAY_ELEM";
    private static final List<Class<? extends FunctionExpression>> CLIENT_SIDE_BUILT_IN_FUNCTIONS = Arrays.asList(CurrentDateFunction.class, CurrentTimeFunction.class, AvgAggregateFunction.class);
    private static final Map<BuiltInFunctionKey, FunctionParseNode.BuiltInFunctionInfo> BUILT_IN_FUNCTION_MAP = Maps.newHashMap();

    private static void addBuiltInFunction(Class<? extends FunctionExpression> f) throws Exception {
        FunctionParseNode.BuiltInFunction d = f.getAnnotation(FunctionParseNode.BuiltInFunction.class);
        if (d == null) {
            return;
        }
        int nArgs = d.args().length;
        FunctionParseNode.BuiltInFunctionInfo value = new FunctionParseNode.BuiltInFunctionInfo(f, d);
        do {
            BuiltInFunctionKey key;
            if (BUILT_IN_FUNCTION_MAP.put(key = new BuiltInFunctionKey(value.getName(), nArgs), value) == null) continue;
            throw new IllegalStateException("Multiple " + value.getName() + " functions with " + nArgs + " arguments");
        } while (--nArgs >= 0 && d.args()[nArgs].defaultValue().length() > 0);
        while (--nArgs >= 0) {
            if (d.args()[nArgs].defaultValue().length() <= 0) continue;
            throw new IllegalStateException("Function " + value.getName() + " has non trailing default value of '" + d.args()[nArgs].defaultValue() + "'. Only trailing arguments may have default values");
        }
    }

    private static synchronized void initBuiltInFunctionMap() {
        if (!BUILT_IN_FUNCTION_MAP.isEmpty()) {
            return;
        }
        Class<Expression> f = null;
        try {
            for (int i = 0; i < CLIENT_SIDE_BUILT_IN_FUNCTIONS.size(); ++i) {
                f = CLIENT_SIDE_BUILT_IN_FUNCTIONS.get(i);
                ParseNodeFactory.addBuiltInFunction(f);
            }
            for (ExpressionType et : ExpressionType.values()) {
                Class<? extends Expression> ec = et.getExpressionClass();
                if (!FunctionExpression.class.isAssignableFrom(ec)) continue;
                Class<? extends Expression> c = ec;
                f = c;
                ParseNodeFactory.addBuiltInFunction(f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed initialization of built-in functions at class '" + f + "'", e);
        }
    }

    private static FunctionParseNode.BuiltInFunctionInfo getInfo(String name, List<ParseNode> children) {
        return ParseNodeFactory.get(SchemaUtil.normalizeIdentifier(name), children);
    }

    public static FunctionParseNode.BuiltInFunctionInfo get(String normalizedName, List<ParseNode> children) {
        ParseNodeFactory.initBuiltInFunctionMap();
        FunctionParseNode.BuiltInFunctionInfo info = BUILT_IN_FUNCTION_MAP.get(new BuiltInFunctionKey(normalizedName, children.size()));
        if (info == null) {
            throw new UnknownFunctionException(normalizedName);
        }
        return info;
    }

    public ExplainStatement explain(BindableStatement statement) {
        return new ExplainStatement(statement);
    }

    public AliasedNode aliasedNode(String alias, ParseNode expression) {
        return new AliasedNode(alias, expression);
    }

    public AddParseNode add(List<ParseNode> children) {
        return new AddParseNode(children);
    }

    public SubtractParseNode subtract(List<ParseNode> children) {
        return new SubtractParseNode(children);
    }

    public MultiplyParseNode multiply(List<ParseNode> children) {
        return new MultiplyParseNode(children);
    }

    public AndParseNode and(List<ParseNode> children) {
        return new AndParseNode(children);
    }

    public FamilyWildcardParseNode family(String familyName) {
        return new FamilyWildcardParseNode(familyName, false);
    }

    public TableWildcardParseNode tableWildcard(TableName tableName) {
        return new TableWildcardParseNode(tableName, false);
    }

    public WildcardParseNode wildcard() {
        return WildcardParseNode.INSTANCE;
    }

    public BetweenParseNode between(ParseNode l, ParseNode r1, ParseNode r2, boolean negate) {
        return new BetweenParseNode(l, r1, r2, negate);
    }

    public BindParseNode bind(String bind) {
        return new BindParseNode(bind);
    }

    public StringConcatParseNode concat(List<ParseNode> children) {
        return new StringConcatParseNode(children);
    }

    public ColumnParseNode column(TableName tableName, String name, String alias) {
        return new ColumnParseNode(tableName, name, alias);
    }

    public ColumnName columnName(String columnName) {
        return new ColumnName(columnName);
    }

    public ColumnName columnName(String familyName, String columnName) {
        return new ColumnName(familyName, columnName);
    }

    public PropertyName propertyName(String propertyName) {
        return new PropertyName(propertyName);
    }

    public PropertyName propertyName(String familyName, String propertyName) {
        return new PropertyName(familyName, propertyName);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder) {
        return new ColumnDef(columnDefName, sqlTypeName, isNull, maxLength, scale, isPK, sortOrder);
    }

    public ColumnDef columnDef(ColumnName columnDefName, String sqlTypeName, boolean isArray, Integer arrSize, Boolean isNull, Integer maxLength, Integer scale, boolean isPK, SortOrder sortOrder) {
        return new ColumnDef(columnDefName, sqlTypeName, isArray, arrSize, isNull, maxLength, scale, isPK, sortOrder);
    }

    public PrimaryKeyConstraint primaryKey(String name, List<Pair<ColumnName, SortOrder>> columnNameAndSortOrder) {
        return new PrimaryKeyConstraint(name, columnNameAndSortOrder);
    }

    public CreateTableStatement createTable(TableName tableName, ListMultimap<String, Pair<String, Object>> props, List<ColumnDef> columns, PrimaryKeyConstraint pkConstraint, List<ParseNode> splits, PTableType tableType, boolean ifNotExists, TableName baseTableName, ParseNode tableTypeIdNode, int bindCount) {
        return new CreateTableStatement(tableName, props, columns, pkConstraint, splits, tableType, ifNotExists, baseTableName, tableTypeIdNode, bindCount);
    }

    public CreateIndexStatement createIndex(NamedNode indexName, NamedTableNode dataTable, PrimaryKeyConstraint pkConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, int bindCount) {
        return new CreateIndexStatement(indexName, dataTable, pkConstraint, includeColumns, splits, props, ifNotExists, bindCount);
    }

    public CreateSequenceStatement createSequence(TableName tableName, ParseNode startsWith, ParseNode incrementBy, ParseNode cacheSize, boolean ifNotExits, int bindCount) {
        return new CreateSequenceStatement(tableName, startsWith, incrementBy, cacheSize, ifNotExits, bindCount);
    }

    public DropSequenceStatement dropSequence(TableName tableName, boolean ifExits, int bindCount) {
        return new DropSequenceStatement(tableName, ifExits, bindCount);
    }

    public SequenceValueParseNode currentValueFor(TableName tableName) {
        return new SequenceValueParseNode(tableName, SequenceValueParseNode.Op.CURRENT_VALUE);
    }

    public SequenceValueParseNode nextValueFor(TableName tableName) {
        return new SequenceValueParseNode(tableName, SequenceValueParseNode.Op.NEXT_VALUE);
    }

    public AddColumnStatement addColumn(NamedTableNode table, PTableType tableType, List<ColumnDef> columnDefs, boolean ifNotExists, Map<String, Object> props) {
        return new AddColumnStatement(table, tableType, columnDefs, ifNotExists, props);
    }

    public DropColumnStatement dropColumn(NamedTableNode table, PTableType tableType, List<ColumnName> columnNodes, boolean ifExists) {
        return new DropColumnStatement(table, tableType, columnNodes, ifExists);
    }

    public DropTableStatement dropTable(TableName tableName, PTableType tableType, boolean ifExists) {
        return new DropTableStatement(tableName, tableType, ifExists);
    }

    public DropIndexStatement dropIndex(NamedNode indexName, TableName tableName, boolean ifExists) {
        return new DropIndexStatement(indexName, tableName, ifExists);
    }

    public AlterIndexStatement alterIndex(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState state) {
        return new AlterIndexStatement(indexTableNode, dataTableName, ifExists, state);
    }

    public TableName table(String schemaName, String tableName) {
        return TableName.createNormalized(schemaName, tableName);
    }

    public NamedNode indexName(String name) {
        return new NamedNode(name);
    }

    public NamedTableNode namedTable(String alias, TableName name) {
        return new NamedTableNode(alias, name);
    }

    public NamedTableNode namedTable(String alias, TableName name, List<ColumnDef> dyn_columns) {
        return new NamedTableNode(alias, name, dyn_columns);
    }

    public BindTableNode bindTable(String alias, TableName name) {
        return new BindTableNode(alias, name);
    }

    public CaseParseNode caseWhen(List<ParseNode> children) {
        return new CaseParseNode(children);
    }

    public DivideParseNode divide(List<ParseNode> children) {
        return new DivideParseNode(children);
    }

    public FunctionParseNode functionDistinct(String name, List<ParseNode> args) {
        if ("COUNT".equals(SchemaUtil.normalizeIdentifier(name))) {
            FunctionParseNode.BuiltInFunctionInfo info = ParseNodeFactory.getInfo(SchemaUtil.normalizeIdentifier("DISTINCT_COUNT"), args);
            return new DistinctCountParseNode(name, args, info);
        }
        throw new UnsupportedOperationException("DISTINCT not supported with " + name);
    }

    public FunctionParseNode arrayElemRef(List<ParseNode> args) {
        return this.function(ARRAY_ELEM, args);
    }

    public FunctionParseNode function(String name, List<ParseNode> args) {
        FunctionParseNode.BuiltInFunctionInfo info = ParseNodeFactory.getInfo(name, args);
        Constructor<? extends FunctionParseNode> ctor = info.getNodeCtor();
        if (ctor == null) {
            return info.isAggregate() ? new AggregateFunctionParseNode(name, args, info) : new FunctionParseNode(name, args, info);
        }
        try {
            return ctor.newInstance(name, args, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FunctionParseNode function(String name, List<ParseNode> valueNodes, List<ParseNode> columnNodes, boolean isAscending) {
        if (valueNodes.size() != 1 || columnNodes.size() != 1) {
            throw new UnsupportedOperationException(name + " not supported on multiple columns");
        }
        ArrayList<ParseNode> children = new ArrayList<ParseNode>(3);
        children.add(columnNodes.get(0));
        children.add(new LiteralParseNode(isAscending));
        children.add(valueNodes.get(0));
        return this.function(name, children);
    }

    public HintNode hint(String hint) {
        return new HintNode(hint);
    }

    public InListParseNode inList(List<ParseNode> children, boolean negate) {
        return new InListParseNode(children, negate);
    }

    public ExistsParseNode exists(ParseNode l, ParseNode r, boolean negate) {
        return new ExistsParseNode(l, r, negate);
    }

    public InParseNode in(ParseNode l, ParseNode r, boolean negate) {
        return new InParseNode(l, r, negate);
    }

    public IsNullParseNode isNull(ParseNode child, boolean negate) {
        return new IsNullParseNode(child, negate);
    }

    public JoinTableNode join(JoinTableNode.JoinType type, ParseNode on, TableNode table) {
        return new JoinTableNode(type, on, table);
    }

    public DerivedTableNode derivedTable(String alias, SelectStatement select) {
        return new DerivedTableNode(alias, select);
    }

    public LikeParseNode like(ParseNode lhs, ParseNode rhs, boolean negate) {
        return new LikeParseNode(lhs, rhs, negate);
    }

    public LiteralParseNode literal(Object value) {
        return new LiteralParseNode(value);
    }

    public CastParseNode cast(ParseNode expression, String dataType, Integer maxLength, Integer scale) {
        return new CastParseNode(expression, dataType, maxLength, scale, false);
    }

    public CastParseNode cast(ParseNode expression, PDataType dataType, Integer maxLength, Integer scale) {
        return new CastParseNode(expression, dataType, maxLength, scale, false);
    }

    public CastParseNode cast(ParseNode expression, PDataType dataType, Integer maxLength, Integer scale, boolean arr) {
        return new CastParseNode(expression, dataType, maxLength, scale, arr);
    }

    public CastParseNode cast(ParseNode expression, String dataType, Integer maxLength, Integer scale, boolean arr) {
        return new CastParseNode(expression, dataType, maxLength, scale, arr);
    }

    public ParseNode rowValueConstructor(List<ParseNode> l) {
        return new RowValueConstructorParseNode(l);
    }

    private void checkTypeMatch(PDataType expectedType, PDataType actualType) throws SQLException {
        if (!expectedType.isCoercibleTo(actualType)) {
            throw TypeMismatchException.newException(expectedType, actualType);
        }
    }

    public LiteralParseNode literal(Object value, PDataType expectedType) throws SQLException {
        PDataType actualType = PDataType.fromLiteral(value);
        if (actualType != null && actualType != expectedType) {
            this.checkTypeMatch(expectedType, actualType);
            value = expectedType.toObject(value, actualType);
        }
        return new LiteralParseNode(value);
    }

    public LiteralParseNode coerce(LiteralParseNode literalNode, PDataType expectedType) throws SQLException {
        PDataType actualType = literalNode.getType();
        if (actualType != null) {
            Object before = literalNode.getValue();
            this.checkTypeMatch(expectedType, actualType);
            Object after = expectedType.toObject(before, actualType);
            if (before != after) {
                literalNode = this.literal(after);
            }
        }
        return literalNode;
    }

    public ComparisonParseNode comparison(CompareFilter.CompareOp op, ParseNode lhs, ParseNode rhs) {
        switch (op) {
            case LESS: {
                return this.lt(lhs, rhs);
            }
            case LESS_OR_EQUAL: {
                return this.lte(lhs, rhs);
            }
            case EQUAL: {
                return this.equal(lhs, rhs);
            }
            case NOT_EQUAL: {
                return this.notEqual(lhs, rhs);
            }
            case GREATER_OR_EQUAL: {
                return this.gte(lhs, rhs);
            }
            case GREATER: {
                return this.gt(lhs, rhs);
            }
        }
        throw new IllegalArgumentException("Unexpcted CompareOp of " + (Object)((Object)op));
    }

    public GreaterThanParseNode gt(ParseNode lhs, ParseNode rhs) {
        return new GreaterThanParseNode(lhs, rhs);
    }

    public GreaterThanOrEqualParseNode gte(ParseNode lhs, ParseNode rhs) {
        return new GreaterThanOrEqualParseNode(lhs, rhs);
    }

    public LessThanParseNode lt(ParseNode lhs, ParseNode rhs) {
        return new LessThanParseNode(lhs, rhs);
    }

    public LessThanOrEqualParseNode lte(ParseNode lhs, ParseNode rhs) {
        return new LessThanOrEqualParseNode(lhs, rhs);
    }

    public EqualParseNode equal(ParseNode lhs, ParseNode rhs) {
        return new EqualParseNode(lhs, rhs);
    }

    public ArrayConstructorNode upsertStmtArrayNode(List<ParseNode> upsertStmtArray) {
        return new ArrayConstructorNode(upsertStmtArray);
    }

    public MultiplyParseNode negate(ParseNode child) {
        return new MultiplyParseNode(Arrays.asList(child, this.literal(-1)));
    }

    public NotEqualParseNode notEqual(ParseNode lhs, ParseNode rhs) {
        return new NotEqualParseNode(lhs, rhs);
    }

    public NotParseNode not(ParseNode child) {
        return new NotParseNode(child);
    }

    public OrParseNode or(List<ParseNode> children) {
        return new OrParseNode(children);
    }

    public OrderByNode orderBy(ParseNode expression, boolean nullsLast, boolean orderAscending) {
        return new OrderByNode(expression, nullsLast, orderAscending);
    }

    public OuterJoinParseNode outer(ParseNode node) {
        return new OuterJoinParseNode(node);
    }

    public SelectStatement select(List<? extends TableNode> from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, int bindCount, boolean isAggregate) {
        return new SelectStatement(from, hint, isDistinct, select, where, groupBy == null ? Collections.emptyList() : groupBy, having, orderBy == null ? Collections.emptyList() : orderBy, limit, bindCount, isAggregate);
    }

    public UpsertStatement upsert(NamedTableNode table, HintNode hint, List<ColumnName> columns, List<ParseNode> values, SelectStatement select, int bindCount) {
        return new UpsertStatement(table, hint, columns, values, select, bindCount);
    }

    public DeleteStatement delete(NamedTableNode table, HintNode hint, ParseNode node, List<OrderByNode> orderBy, LimitNode limit, int bindCount) {
        return new DeleteStatement(table, hint, node, orderBy, limit, bindCount);
    }

    public SelectStatement select(SelectStatement statement, ParseNode where, ParseNode having) {
        return this.select(statement.getFrom(), statement.getHint(), statement.isDistinct(), statement.getSelect(), where, statement.getGroupBy(), having, statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate());
    }

    public SelectStatement select(SelectStatement statement, List<? extends TableNode> tables) {
        return this.select(tables, statement.getHint(), statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate());
    }

    public SelectStatement select(SelectStatement statement, HintNode hint) {
        return hint == null || hint.isEmpty() ? statement : this.select(statement.getFrom(), hint, statement.isDistinct(), statement.getSelect(), statement.getWhere(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate());
    }

    public SubqueryParseNode subquery(SelectStatement select) {
        return new SubqueryParseNode(select);
    }

    public LimitNode limit(BindParseNode b) {
        return new LimitNode(b);
    }

    public LimitNode limit(LiteralParseNode l) {
        return new LimitNode(l);
    }

    private static class BuiltInFunctionKey {
        private final String upperName;
        private final int argCount;

        private BuiltInFunctionKey(String lowerName, int argCount) {
            this.upperName = lowerName;
            this.argCount = argCount;
        }

        public String toString() {
            return this.upperName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.argCount;
            result = 31 * result + (this.upperName == null ? 0 : this.upperName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuiltInFunctionKey other = (BuiltInFunctionKey)obj;
            if (this.argCount != other.argCount) {
                return false;
            }
            return this.upperName.equals(other.upperName);
        }
    }
}

