/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.schema.SortOrder;

public class PrimaryKeyConstraint
extends NamedNode {
    public static final PrimaryKeyConstraint EMPTY = new PrimaryKeyConstraint(null, Collections.<Pair<ColumnName, SortOrder>>emptyList());
    private final List<Pair<ColumnName, SortOrder>> columns;
    private final HashMap<ColumnName, Pair<ColumnName, SortOrder>> columnNameToSortOrder;

    PrimaryKeyConstraint(String name, List<Pair<ColumnName, SortOrder>> columns) {
        super(name);
        this.columns = columns == null ? Collections.emptyList() : ImmutableList.copyOf(columns);
        this.columnNameToSortOrder = Maps.newHashMapWithExpectedSize(this.columns.size());
        for (Pair<ColumnName, SortOrder> p : this.columns) {
            this.columnNameToSortOrder.put(p.getFirst(), p);
        }
    }

    public List<Pair<ColumnName, SortOrder>> getColumnNames() {
        return this.columns;
    }

    public Pair<ColumnName, SortOrder> getColumn(ColumnName columnName) {
        return this.columnNameToSortOrder.get(columnName);
    }

    public boolean contains(ColumnName columnName) {
        return this.columnNameToSortOrder.containsKey(columnName);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

