/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.expression.function.RoundTimestampExpression;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.TypeMismatchException;

public class RoundParseNode
extends FunctionParseNode {
    RoundParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public Expression create(List<Expression> children, StatementContext context) throws SQLException {
        return RoundParseNode.getRoundExpression(children);
    }

    public static Expression getRoundExpression(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        if (firstChildDataType.isCoercibleTo(PDataType.DATE)) {
            return RoundDateExpression.create(children);
        }
        if (firstChildDataType.isCoercibleTo(PDataType.TIMESTAMP)) {
            return RoundTimestampExpression.create(children);
        }
        if (firstChildDataType.isCoercibleTo(PDataType.DECIMAL)) {
            return new RoundDecimalExpression(children);
        }
        throw TypeMismatchException.newException(firstChildDataType, "1");
    }

    @Override
    public boolean evalToNullIfParamIsNull(StatementContext context, int index) throws SQLException {
        return index == 0;
    }
}

