/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AggregateFunctionParseNode;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.schema.Sequence;

public class SelectStatement
implements FilterableStatement {
    public static final SelectStatement SELECT_ONE = new SelectStatement(Collections.emptyList(), null, false, Collections.singletonList(new AliasedNode(null, new LiteralParseNode(1))), null, Collections.<ParseNode>emptyList(), null, Collections.<OrderByNode>emptyList(), null, 0, false);
    public static final SelectStatement COUNT_ONE = new SelectStatement(Collections.emptyList(), null, false, Collections.singletonList(new AliasedNode(null, new AggregateFunctionParseNode(CountAggregateFunction.NORMALIZED_NAME, LiteralParseNode.STAR, new FunctionParseNode.BuiltInFunctionInfo(CountAggregateFunction.class, CountAggregateFunction.class.getAnnotation(FunctionParseNode.BuiltInFunction.class))))), null, Collections.<ParseNode>emptyList(), null, Collections.<OrderByNode>emptyList(), null, 0, true);
    private final List<TableNode> fromTable;
    private final HintNode hint;
    private final boolean isDistinct;
    private final List<AliasedNode> select;
    private final ParseNode where;
    private final List<ParseNode> groupBy;
    private final ParseNode having;
    private final List<OrderByNode> orderBy;
    private final LimitNode limit;
    private final int bindCount;
    private final boolean isAggregate;

    public static SelectStatement create(SelectStatement select, HintNode hint) {
        if (select.getHint() == hint || hint.isEmpty()) {
            return select;
        }
        return new SelectStatement(select.getFrom(), hint, select.isDistinct(), select.getSelect(), select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getBindCount(), select.isAggregate());
    }

    public SelectStatement combine(ParseNode where) {
        if (where == null) {
            return this;
        }
        if (this.getWhere() != null) {
            where = new AndParseNode(Arrays.asList(this.getWhere(), where));
        }
        return new SelectStatement(this.getFrom(), this.getHint(), this.isDistinct(), this.getSelect(), where, this.getGroupBy(), this.getHaving(), this.getOrderBy(), this.getLimit(), this.getBindCount(), this.isAggregate());
    }

    public static SelectStatement create(SelectStatement select, List<AliasedNode> selects) {
        return new SelectStatement(select.getFrom(), select.getHint(), select.isDistinct(), selects, select.getWhere(), select.getGroupBy(), select.getHaving(), select.getOrderBy(), select.getLimit(), select.getBindCount(), select.isAggregate());
    }

    private static int countConstants(List<ParseNode> nodes) {
        int count = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get(i).isStateless()) continue;
            ++count;
        }
        return count;
    }

    protected SelectStatement(List<? extends TableNode> from, HintNode hint, boolean isDistinct, List<AliasedNode> select, ParseNode where, List<ParseNode> groupBy, ParseNode having, List<OrderByNode> orderBy, LimitNode limit, int bindCount, boolean isAggregate) {
        this.fromTable = Collections.unmodifiableList(from);
        this.hint = hint == null ? HintNode.EMPTY_HINT_NODE : hint;
        this.isDistinct = isDistinct;
        this.select = Collections.unmodifiableList(select);
        this.where = where;
        this.groupBy = Collections.unmodifiableList(groupBy);
        this.having = having;
        this.orderBy = Collections.unmodifiableList(orderBy);
        this.limit = limit;
        this.bindCount = bindCount;
        this.isAggregate = isAggregate || groupBy.size() != SelectStatement.countConstants(groupBy) || this.having != null;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public LimitNode getLimit() {
        return this.limit;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    public List<TableNode> getFrom() {
        return this.fromTable;
    }

    @Override
    public HintNode getHint() {
        return this.hint;
    }

    public List<AliasedNode> getSelect() {
        return this.select;
    }

    @Override
    public ParseNode getWhere() {
        return this.where;
    }

    public List<ParseNode> getGroupBy() {
        return this.groupBy;
    }

    public ParseNode getHaving() {
        return this.having;
    }

    @Override
    public List<OrderByNode> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public PhoenixStatement.Operation getOperation() {
        return PhoenixStatement.Operation.QUERY;
    }

    @Override
    public Sequence.Action getSequenceAction() {
        return Sequence.Action.RESERVE;
    }
}

